/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class StartTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;
    private final GoToEnable enabler = new GoToEnable();

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void startTestFailure() {
        try {
            this.ocsBridge.execute(new StartCommand("Normal"));
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        System.out.println("========================");
        System.out.println(this.executor.getEventCount());
    }

    public void startToDisable() {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.executor.clearEvents();
        this.ocsBridge.execute(new StartCommand("Normal"));
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        System.out.println(" ************************************* ");
        System.out.println("StartTest:startToDisable(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        assert (tl.getStateList().hasState(new Enum[]{SummaryStateEvent.LSE209State.DISABLED}));
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("StartTest:startToDisable():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.DISABLED, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertEquals((long)states.size(), (long)3L);
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("StartTest:startToDisable(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        System.out.println(this.executor.getEventCount());
    }
}

