/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class StandbyTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void stdbyTestFail() {
        try {
            this.ocsBridge.execute(new StandbyCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void stdbyFromDisabledState() {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        this.ocsBridge.execute(new EnterControlCommand());
        this.ocsBridge.execute(new StartCommand("Normal"));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.executor.clearEvents();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new StandbyCommand());
        System.out.println(" ************************************* ");
        System.out.println("StandbyTest:stdbyFromDisabledState(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        Assert.assertEquals((long)1L, (long)this.executor.getEventCount());
        assert (tl.getStateList().hasState(new Enum[]{SummaryStateEvent.LSE209State.STANDBY}));
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("StandbyTest:stdbyFromDisabledState():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.STANDBY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertTrue((boolean)this.executor.containsInOrder(SettingVersionsEvent.class));
    }
}

