/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitGuidersTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;
    private GoToEnable enabler = new GoToEnable();

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void fail() {
        try {
            this.ocsBridge.execute(new InitGuidersCommand("bollocks"));
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void initGuiders() {
        int i;
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new InitGuidersCommand("bollocks"));
        Assert.assertEquals((long)2L, (long)tl.getCalls());
        System.out.println(" ************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTakeEarly(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("InitGuidersTest:initGuiders():List of states");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        System.out.println("************************************* ");
        System.out.println("InitGuiders:initGuiders(): List of Events");
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
    }
}

