/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartRaftIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitAndTakeImageTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;
    private GoToEnable enabler = new GoToEnable();

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void initAndTake() throws InterruptedException, ExecutionException, TimeoutException {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new InitImageCommand(2.0));
        TimeUnit.SECONDS.sleep(2L);
        this.ocsBridge.execute(new TakeImagesCommand(15.0, 2, true, true, true, true, "mockturtle001"));
        TimeUnit.SECONDS.sleep(10L);
        System.out.println(" ************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTake(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterReadinessState.NOT_READY}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        assert (tl.getStateList().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("InitAndTakeImageTest:initAndTake():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((Object)CCSCommandStateEvent.IdleBusyState.BUSY, (Object)states.get(0));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.GETTING_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTake(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)20L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartRaftIntegrationEvent.class, StartRaftIntegrationEvent.class, ImageReadoutParametersEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartReadoutEvent.class, EndReadoutEvent.class, EndOfImageTelemetryEvent.class, StartReadoutEvent.class, EndReadoutEvent.class, EndOfImageTelemetryEvent.class));
        StartRaftIntegrationEvent event1 = this.executor.getEventOfClass(StartRaftIntegrationEvent.class, 0);
        Assert.assertEquals((Object)"mockturtle001", (Object)event1.getImageName());
        StartRaftIntegrationEvent event2 = this.executor.getEventOfClass(StartRaftIntegrationEvent.class, 1);
        Assert.assertEquals((Object)"mockturtle002", (Object)event2.getImageName());
    }

    @Test
    public void initAndTakeEarly() throws InterruptedException, ExecutionException, TimeoutException {
        this.enabler.goToEnable(this.ocsBridge);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new InitImageCommand(2.0));
        TimeUnit.MILLISECONDS.sleep(500L);
        this.ocsBridge.execute(new TakeImagesCommand(15.0, 2, true, true, true, true, "mockturtle002"));
        TimeUnit.SECONDS.sleep(10L);
        System.out.println(" ************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTakeEarly(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterReadinessState.NOT_READY}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        assert (tl.getStateList().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("initAndTakeImageTest:initAndTakeEarly():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTake(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.GETTING_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        StartRaftIntegrationEvent event1 = this.executor.getEventOfClass(StartRaftIntegrationEvent.class, 0);
        Assert.assertEquals((Object)"mockturtle002", (Object)event1.getImageName());
        StartRaftIntegrationEvent event2 = this.executor.getEventOfClass(StartRaftIntegrationEvent.class, 1);
        Assert.assertEquals((Object)"mockturtle003", (Object)event2.getImageName());
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        Assert.assertEquals((long)20L, (long)this.executor.getEventCount());
    }
}

