/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class FullStateHistory {
    private final List<Enum> states = new ArrayList<Enum>();

    void add(Enum state) {
        this.states.add(state);
    }

    boolean hasState(State state) {
        return this.states.contains(state.getState());
    }

    List<Enum> getStates() {
        return this.states;
    }

    boolean containsInOrder(Enum ... targetStates) {
        Iterator<Enum> targetIterator = Arrays.asList(targetStates).iterator();
        if (!targetIterator.hasNext()) {
            return true;
        }
        Enum currentState = targetIterator.next();
        for (Enum state : this.states) {
            if (state != currentState) continue;
            if (!targetIterator.hasNext()) {
                return true;
            }
            currentState = targetIterator.next();
        }
        return false;
    }

    public String toString() {
        String string = "Complete State History : \n";
        for (int i = 0; i < this.states.size(); ++i) {
            string = string + string + " " + this.states.get(i) + " \n";
        }
        return string;
    }
}

