/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class FilterChangeTest {
    private OCSBridge ocsBridge;
    private GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void fail() {
        try {
            this.ocsBridge.execute(new SetFilterCommand("g-9"));
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void filterChange() {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("g-9"));
        Assert.assertEquals((long)6L, (long)tl.getCalls());
        System.out.println(" ************************************* ");
        System.out.println("FilterChangeTest:filterChange(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{Filter.FilterState.LOADED}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("FilterChangeTest:filterChange():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)fsh.getStates().size(), (long)6L);
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, Filter.FilterState.ROTATING, Filter.FilterState.LOADING, Filter.FilterState.LOADED, CCSCommandStateEvent.IdleBusyState.IDLE}));
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:filterChange(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)6L, (long)cameraEvents.size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event1 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"g-9", (Object)event1.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event1.getFilterName());
        System.out.println("************************************* ");
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("NONE"));
        List<CameraEvent> eventsForG9ToNONE = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:filterChange() G9->NONE: List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)eventsForG9ToNONE.size(), (long)4L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event0 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"NONE", (Object)event0.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event0.getFilterName());
        System.out.println("************************************* ");
        System.out.println(" \n");
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("NONE"));
        List<CameraEvent> eventsForNONEToNONE = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:filterChange() NONE->NONE: List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)eventsForNONEToNONE.size(), (long)2L);
        Assert.assertFalse((boolean)this.executor.containsInOrder(StartRotateCarouselEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(EndRotateCarouselEvent.class));
        assert (this.executor.containsInOrder(StartSetFilterEvent.class, EndSetFilterEvent.class));
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("r-1"));
        List<CameraEvent> eventsForNONEToR1 = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:filterChange() NONE->r-1: List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)eventsForNONEToR1.size(), (long)6L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event2 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"r-1", (Object)event2.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event2.getFilterName());
        System.out.println("************************************* ");
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("u-10"));
        List<CameraEvent> eventsForR1ToU10 = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:filterChange(): r-1->u-10: List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)eventsForR1ToU10.size(), (long)8L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event3 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"u-10", (Object)event3.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event3.getFilterName());
        System.out.println("************************************* ");
        System.out.println(" \n");
    }
}

