/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class EnterControlTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void enterControlTestFailure() {
        try {
            this.ocsBridge.execute(new EnterControlCommand());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void enterControlAndFaultTest() {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new EnterControlCommand());
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        System.out.println(" ************************************* ");
        System.out.println("EnterControlTest:enterControlAndFaultTest(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        assert (tl.getStateList().hasState(new Enum[]{SummaryStateEvent.LSE209State.STANDBY}));
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("EnterControlTest:enterControlAndFaultTest():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.STANDBY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertEquals((long)states.size(), (long)3L);
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("EnterControlTest:enterControlAndFaultTest(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)1L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(SettingVersionsEvent.class));
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getStateList().hasState(new Enum[]{SummaryStateEvent.LSE209State.FAULT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        Assert.assertEquals((Object)SummaryStateEvent.LSE209State.FAULT, (Object)states_fault.get(0));
        Assert.assertEquals((long)states_fault.size(), (long)1L);
    }
}

