/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

// A simple Java program to demonstrate the use of reflection
import java.lang.reflect.Method;
import java.lang.reflect.Field;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import static org.lsst.ccs.messaging.NetworkUtilities.instance;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
// specific CCSCommands - 
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSAckOrNack;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSClearCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSClearFaultCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSCommandResponse;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDisableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDiscardRowsCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEnableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEndImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitGuidersCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSPreconditionsNotMet;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSRevokeAvailableCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSetAvailableCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSetFilterCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSimulateFaultCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSTakeImagesCommand;

import org.lsst.sal.camera.CameraCommand;
//specfic imports
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

/**
 *
 * @author Farrukh Azfar
 */
public class OCSCommandConverter {

    // list of CCS (OCS commands actually ) and CameraCommands
    CCSClearCommand ocs1 = new CCSClearCommand(0);
    CCSDisableCalibrationCommand ocs2 = new CCSDisableCalibrationCommand();
    CCSDiscardRowsCommand ocs3 = new CCSDiscardRowsCommand(0);
    CCSEnableCalibrationCommand ocs4 = new CCSEnableCalibrationCommand();
    CCSEndImageCommand ocs5 = new CCSEndImageCommand();
    CCSInitGuidersCommand ocs6 = new CCSInitGuidersCommand("a");
    CCSInitImageCommand ocs7 = new CCSInitImageCommand(0);
    CCSSetFilterCommand ocs8 = new CCSSetFilterCommand("a");
    CCSStartCommand ocs9 = new CCSStartCommand("a");
    CCSStartImageCommand ocs10 = new CCSStartImageCommand("balls", true, true, true, true, 1);
    CCSTakeImagesCommand ocs11 = new CCSTakeImagesCommand(1, 1, true, true, true, true, "balls");

    private final List< CCSCommand> ccsCommands = Arrays.asList(ocs1, ocs2, ocs3, ocs4, ocs5,
            ocs6, ocs7, ocs8, ocs9, ocs10, ocs11);

    ClearCommand cc1 = new ClearCommand(0);
    DisableCalibrationCommand cc2 = new DisableCalibrationCommand();
    DiscardRowsCommand cc3 = new DiscardRowsCommand(0);
    EnableCalibrationCommand cc4 = new EnableCalibrationCommand();
    EndImageCommand cc5 = new EndImageCommand();
    InitGuidersCommand cc6 = new InitGuidersCommand("a");
    InitImageCommand cc7 = new InitImageCommand(0);
    SetFilterCommand cc8 = new SetFilterCommand("a");
    StartCommand cc9 = new StartCommand("a");
    StartImageCommand cc10 = new StartImageCommand("balls", true, true, true, true, 1);
    TakeImagesCommand cc11 = new TakeImagesCommand(1, 1, true, true, true, true, "balls");

    private final List<CameraCommand> cameraCommands = Arrays.asList(cc1, cc2, cc3, cc4, cc5,
            cc6, cc7, cc8, cc9, cc10, cc11);

    private Map<CCSCommand, CameraCommand> map = new HashMap<CCSCommand, CameraCommand>();

//constructor builds the hashmap 
    public OCSCommandConverter() {

        for (int i = 0; i < ccsCommands.size(); i++) {
            map.put(ccsCommands.get(i), cameraCommands.get(i));
        }

    }

public    CameraCommand convert(CCSCommand myCommand) throws IllegalArgumentException, IllegalAccessException {

        // get ocs command 
        // get its instance 
        // make a copy of the same command with fields appropriately made
        // construct a CCS command with the same fields
        // return a Camera command
        // get the command to issue - 
        CameraCommand commandToIssue = map.get(myCommand.getClass());

        Field[] ocsCommandFields = myCommand.getClass().getFields();
        Field[] cameraCommandFields = commandToIssue.getClass().getFields();

        for (Field ocsCommandField : ocsCommandFields) {
            for (Field cameraCommandField : cameraCommandFields) {
                if(ocsCommandField.getType().equals(cameraCommandField.getType()) && 
                        ocsCommandField.getName().equals(cameraCommandField.getName())) {
                    
                    cameraCommandField.set(commandToIssue, ocsCommandField.get(myCommand));
                }
              

            }
        }

        return commandToIssue;
    }
}
