package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Base class for CCS Events
 *
 * @author tonyj
 */
public class Event {

    static class EventListenerList {

        private final List<EventListener> listeners = new CopyOnWriteArrayList<>();

        void addEventListener(EventListener l) {
            listeners.add(l);
        }

        void removeEventListener(EventListener l) {
            listeners.remove(l);
        }
        
        void fireEvent(Event event) {
            listeners.forEach((l) -> {
                l.eventFired(event);
            });
        }
    }

    public interface EventListener {

        public void eventFired(Event event);
    }
}
