package org.lsst.ccs.subsystem.ocsbridge.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.subsystem.ocsbridge.util.Event.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.Event.EventListenerList;
import org.lsst.ccs.subsystem.ocsbridge.util.State.StateChangeListener;

/**
 * Trivial CCS simulation. This class deals with routing status messages and
 * scheduling actions. it also allows status listeners to be added which will
 * receive notification of any status change.
 *
 * @author tonyj
 */
public class CCS {

    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    private final EventListenerList eventListenerList = new EventListenerList();

    private final AggregateStatus as = new AggregateStatus();

    <T> ScheduledFuture<T> schedule(Duration when, Callable<T> callable) {
        return scheduler.schedule(callable, when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Duration when, Runnable runnable) {
        return scheduler.schedule(runnable, when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void addStateChangeListener(StateChangeListener<? extends Enum> listener) {
        as.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(StateChangeListener<? extends Enum> listener) {
        as.removeStateChangeListener(listener);
    }

    public void addEventListener(EventListener listener) {
        eventListenerList.addEventListener(listener);
    }

    public void removeEventListener(EventListener listener) {
        eventListenerList.removeEventListener(listener);
    }
    
    public void runInBackground(Runnable r) {
        scheduler.execute(r);
    }

    void shutdown() {
        scheduler.shutdown();
    }

    public AggregateStatus getAggregateStatus() {
        return as;
    }

    public Future<Void> waitForStatus(Enum state) {
        return as.waitForStatus(state);
    }

    public void fireEvent(Event event) {
        eventListenerList.fireEvent(event);
    }

    public void schduleAtFixedRate(int i, TimeUnit timeUnit, Runnable runnable) {
        scheduler.scheduleAtFixedRate(runnable, i, i, timeUnit);
    }
}
