package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

/**
 * An interface for talking to a real rafts subsystem.
 * Temporary for DAQ-DM_FILES exercise
 * @author tonyj
 */
class RaftsSubsystemLayer {

    private static final Logger LOG = Logger.getLogger(RaftsSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    
    RaftsSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void acquireImage(String imageName) {
        sendCommand("acquireImage "+imageName);
        sendCommand("waitForImage 10000");
        if (config.getFitsDir() != null) {
            sendCommand("saveFitsImage "+config.getFitsDir());
        }
    }

    void startIntegration() {
        sendCommand("loadSequencer "+config.getSequencerFile());
    }

    private void sendCommand(String command) {
        CommandRequest request = new CommandRequest(config.getRaftsSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request);
        } catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
}
