package org.lsst.ccs.subsystem.ocsbridge.sim;

import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.util.Event.EventListener;

/**
 * An implementation of MCMLayer which works by directly forwarding requests
 * to an in-process implementation of the MCM.
 * @author tonyj
 */
public class MCMDirectLayer implements MCMLayer {

    private final MCM mcm;

    /**
     * Create an MCMDirectLayer object
     * @param mcm The MCM to which functionality will be forwarded.
     */
    public MCMDirectLayer(MCM mcm) {
        this.mcm = mcm;
    }

    @Override
    public CCSCommand.CCSCommandResponse execute(CCSCommand ccsCommand) {
        return mcm.execute(ccsCommand);
    }

    @Override
    public void addStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        mcm.getCCS().addStateChangeListener(stateChangeListener);
    }

    @Override
    public void removeStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        mcm.getCCS().removeStateChangeListener(stateChangeListener);
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        mcm.getCCS().addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        mcm.getCCS().addEventListener(eventListener);
    }
    
}
