package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.Event.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State.StateChangeListener;
import org.lsst.sal.camera.CameraCommand;

/**
 * This interface represents the information the ToyOCSGIO requires to be able
 * to interact with the OCS bridge (either directly, or via the OCS buses)
 *
 * @author tonyj
 */
interface GUILayer {

    public void execute(CameraCommand cmd);
    public boolean supportsCCSCommands();
    public void execute(CCSCommand command);
    
    public AggregateStatus getAggregateStatus();

    // Maybe these should be methods on aggregate status
    void addStateChangeListener(StateChangeListener<? extends Enum> listener);
    void removeStateChangeListener(StateChangeListener<? extends Enum> listener);
    
    void addEventListener(EventListener listener);
    void removeEventListener(EventListener listener);
}
