package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;

/**
 * An implementation of GUILayer which talks directly to the OCSBridge
 *
 * @author tonyj
 */
class GUIDirectLayer implements GUILayer {

    private final OCSBridge bridge;

    GUIDirectLayer(OCSBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void execute(CameraCommand cmd) {
        bridge.execute(cmd);
    }

    @Override
    public AggregateStatus getAggregateStatus() {
        return bridge.getCCS().getAggregateStatus();
    }

    @Override
    public void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        bridge.getCCS().addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        bridge.getCCS().addStateChangeListener(listener);
    }

    @Override
    public void execute(CCSCommand command) {
        bridge.execute(command);
    }

    @Override
    public boolean supportsCCSCommands() {
        return true;
    }

    @Override
    public void addEventListener(Event.EventListener listener) {
        bridge.getCCS().addEventListener(listener);
    }

    @Override
    public void removeEventListener(Event.EventListener listener) {
        bridge.getCCS().addEventListener(listener);
    }

}
