package org.lsst.ccs.subsystem.ocsbridge;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author tonyj
 */
public class CCSCommandExecutor {

    private static final Logger logger = Logger.getLogger(OCSBridge.class.getName());

    void executeCommand(CCSCommand.CCSCommandResponse response) {
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            logger.log(Level.INFO, "Command rejected: {0}", can.getReason());
            sendNack(can);
        } else {
            try {
                sendAck(can);
                response.waitForCompletion();
                logger.log(Level.INFO, "Command complete");
            } catch (Exception x) {
                logger.log(Level.INFO, "Command failed", x);
            }
        }
    }

    void sendNack(CCSCommand.CCSAckOrNack can) {
    }

    void sendAck(CCSCommand.CCSAckOrNack can) {
    }
}
