/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

public class OCSCommandConverter {
    CCSCommand.CCSClearCommand ocs1 = new CCSCommand.CCSClearCommand(0);
    CCSCommand.CCSDisableCalibrationCommand ocs2 = new CCSCommand.CCSDisableCalibrationCommand();
    CCSCommand.CCSDiscardRowsCommand ocs3 = new CCSCommand.CCSDiscardRowsCommand(0);
    CCSCommand.CCSEnableCalibrationCommand ocs4 = new CCSCommand.CCSEnableCalibrationCommand();
    CCSCommand.CCSEndImageCommand ocs5 = new CCSCommand.CCSEndImageCommand();
    CCSCommand.CCSInitGuidersCommand ocs6 = new CCSCommand.CCSInitGuidersCommand("a");
    CCSCommand.CCSInitImageCommand ocs7 = new CCSCommand.CCSInitImageCommand(0.0);
    CCSCommand.CCSSetFilterCommand ocs8 = new CCSCommand.CCSSetFilterCommand("a");
    CCSCommand.CCSStartCommand ocs9 = new CCSCommand.CCSStartCommand("a");
    CCSCommand.CCSStartImageCommand ocs10 = new CCSCommand.CCSStartImageCommand("balls", true, true, true, true, 1.0);
    CCSCommand.CCSTakeImagesCommand ocs11 = new CCSCommand.CCSTakeImagesCommand(1.0, 1, true, true, true, true, "balls");
    private final List<CCSCommand> ccsCommands = Arrays.asList(this.ocs1, this.ocs2, this.ocs3, this.ocs4, this.ocs5, this.ocs6, this.ocs7, this.ocs8, this.ocs9, this.ocs10, this.ocs11);
    ClearCommand cc1 = new ClearCommand(0);
    DisableCalibrationCommand cc2 = new DisableCalibrationCommand();
    DiscardRowsCommand cc3 = new DiscardRowsCommand(0);
    EnableCalibrationCommand cc4 = new EnableCalibrationCommand();
    EndImageCommand cc5 = new EndImageCommand();
    InitGuidersCommand cc6 = new InitGuidersCommand("a");
    InitImageCommand cc7 = new InitImageCommand(0.0);
    SetFilterCommand cc8 = new SetFilterCommand("a");
    StartCommand cc9 = new StartCommand("a");
    StartImageCommand cc10 = new StartImageCommand("balls", true, true, true, true, 1.0);
    TakeImagesCommand cc11 = new TakeImagesCommand(1.0, 1, true, true, true, true, "balls");
    private final List<CameraCommand> cameraCommands = Arrays.asList(this.cc1, this.cc2, this.cc3, this.cc4, this.cc5, this.cc6, this.cc7, this.cc8, this.cc9, this.cc10, this.cc11);
    private Map<CCSCommand, CameraCommand> map = new HashMap<CCSCommand, CameraCommand>();

    public OCSCommandConverter() {
        for (int i = 0; i < this.ccsCommands.size(); ++i) {
            this.map.put(this.ccsCommands.get(i), this.cameraCommands.get(i));
        }
    }

    public CameraCommand convert(CCSCommand myCommand) throws IllegalArgumentException, IllegalAccessException {
        CameraCommand commandToIssue = this.map.get(myCommand.getClass());
        Field[] ocsCommandFields = myCommand.getClass().getFields();
        Field[] cameraCommandFields = commandToIssue.getClass().getFields();
        for (Field ocsCommandField : ocsCommandFields) {
            for (Field cameraCommandField : cameraCommandFields) {
                if (!ocsCommandField.getType().equals(cameraCommandField.getType()) || !ocsCommandField.getName().equals(cameraCommandField.getName())) continue;
                cameraCommandField.set(commandToIssue, ocsCommandField.get(myCommand));
            }
        }
        return commandToIssue;
    }
}

