/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class Shutter {
    static final Duration PREP_TIME = Duration.ofMillis(150L);
    static final Duration READY_TIME = Duration.ofMillis(4000L);
    static final Duration READY_TIME_FOR_SEVERAL_IMAGES = Duration.ofMillis(10000L);
    static final Duration MOVE_TIME = Duration.ofMillis(980L);
    public boolean imageSequence = false;
    private final State shutterReadinessState;
    private final State shutterState;
    private ScheduledFuture<?> notReadyFuture;
    private final CCS ccs;

    Shutter(CCS ccs) {
        this.ccs = ccs;
        this.shutterReadinessState = new State<ShutterReadinessState>(ShutterReadinessState.NOT_READY);
        ccs.getAggregateStatus().add(this.shutterReadinessState);
        this.shutterState = new State<ShutterState>(ShutterState.CLOSED);
        ccs.getAggregateStatus().add(this.shutterState);
        this.shutterState.addStateChangeListener((state, oldState) -> {
            if (state == ShutterState.CLOSED) {
                this.scheduleNotReady();
            } else {
                this.cancelNotReady();
            }
        });
    }

    public void startImageSequence() {
        this.imageSequence = true;
    }

    public void endImageSequence() {
        this.imageSequence = false;
    }

    private void scheduleNotReady() {
        Duration ready_time = this.imageSequence ? READY_TIME_FOR_SEVERAL_IMAGES : READY_TIME;
        this.notReadyFuture = this.ccs.schedule(ready_time, () -> this.shutterReadinessState.setState(ShutterReadinessState.NOT_READY));
    }

    private void cancelNotReady() {
        if (this.notReadyFuture != null) {
            this.notReadyFuture.cancel(false);
        }
    }

    void prepare() {
        this.cancelNotReady();
        this.shutterReadinessState.setState(ShutterReadinessState.GETTING_READY);
        this.ccs.schedule(PREP_TIME, () -> {
            this.shutterReadinessState.setState(ShutterReadinessState.READY);
            this.scheduleNotReady();
        });
    }

    void expose(Duration exposureTime) {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutterState.checkState(new Enum[]{ShutterState.CLOSED});
        this.shutterState.setState(ShutterState.OPENING);
        Duration time = MOVE_TIME;
        this.ccs.schedule(time, () -> this.shutterState.setState(ShutterState.OPEN));
        time = time.plus(exposureTime);
        this.ccs.schedule(time, () -> this.shutterState.setState(ShutterState.CLOSING));
        time = time.plus(MOVE_TIME);
        this.ccs.schedule(time, () -> this.shutterState.setState(ShutterState.CLOSED));
    }

    void open() {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutterState.checkState(new Enum[]{ShutterState.CLOSED});
        this.shutterState.setState(ShutterState.OPENING);
        this.ccs.schedule(MOVE_TIME, () -> this.shutterState.setState(ShutterState.OPEN));
    }

    void close() {
        if (!this.shutterState.isInState(ShutterState.CLOSED)) {
            this.shutterState.checkState(new Enum[]{ShutterState.OPEN});
            this.shutterState.setState(ShutterState.CLOSING);
            this.ccs.schedule(MOVE_TIME, () -> this.shutterState.setState(ShutterState.CLOSED));
        }
    }

    public static enum ShutterState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }

    public static enum ShutterReadinessState {
        NOT_READY,
        READY,
        GETTING_READY;

    }
}

