/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class RaftsSubsystemLayer {
    private static final Logger LOG = Logger.getLogger(RaftsSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;

    RaftsSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void acquireImage(String imageName) {
        this.sendCommand("acquireImage " + imageName);
        this.sendCommand("waitForImage 10000");
        if (this.config.getFitsDir() != null) {
            this.sendCommand("saveFitsImage " + this.config.getFitsDir());
        }
    }

    void startIntegration() {
        this.sendCommand("loadSequencer " + this.config.getSequencerFile());
    }

    private void sendCommand(String command) {
        CommandRequest request = new CommandRequest(this.config.getRaftsSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
}

