/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class Filter {
    static final Duration LOAD_TIME = Duration.ofMillis(15000L);
    static final Duration ROTATION_TIME_PER_DEGREE = Duration.ofMillis(100L);
    static final Duration UNLOAD_TIME = Duration.ofMillis(15000L);
    private final List<String> availableFilters = new ArrayList<String>();
    private InstalledFilter currentFilter = InstalledFilter.NONE;
    private int currentRotationPosition = 0;
    private final State filterState;
    private final CCS ccs;

    Filter(CCS ccs) {
        this.ccs = ccs;
        for (InstalledFilter f : InstalledFilter.values()) {
            this.availableFilters.add(f.toString());
        }
        this.filterState = new State<FilterState>(FilterState.UNLOADED);
        ccs.getAggregateStatus().add(this.filterState);
    }

    boolean filterIsAvailable(String filter) {
        return this.availableFilters.contains(filter);
    }

    List<String> getAvailableFilters() {
        return Collections.unmodifiableList(this.availableFilters);
    }

    void setFilter(String filter) throws InterruptedException, ExecutionException, TimeoutException {
        int position = this.availableFilters.indexOf(filter);
        if (position < 0) {
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
        InstalledFilter requestedFilter = InstalledFilter.values()[position];
        if (!requestedFilter.equals((Object)this.currentFilter)) {
            if (requestedFilter == InstalledFilter.NONE) {
                this.filterState.setState(FilterState.UNLOADING);
                Future<Void> waitForUnloaded = this.ccs.waitForStatus(FilterState.UNLOADED);
                this.ccs.schedule(UNLOAD_TIME, () -> {
                    this.filterState.setState(FilterState.UNLOADED);
                    this.currentFilter = InstalledFilter.NONE;
                });
                waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
            } else {
                int targetRotation;
                if (this.currentFilter != InstalledFilter.NONE) {
                    this.filterState.setState(FilterState.UNLOADING);
                    Future<Void> waitForUnloaded = this.ccs.waitForStatus(FilterState.UNLOADED);
                    this.ccs.schedule(UNLOAD_TIME, () -> {
                        this.filterState.setState(FilterState.UNLOADED);
                        this.currentFilter = InstalledFilter.NONE;
                    });
                    waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                }
                if (this.currentRotationPosition != (targetRotation = (position - 1) * 360 / 5)) {
                    int degreesToRotate = Math.abs(this.currentRotationPosition - targetRotation) % 360;
                    this.filterState.setState(FilterState.ROTATING);
                    Future<Void> waitForRotation = this.ccs.waitForStatus(FilterState.UNLOADED);
                    Duration rotationTime = ROTATION_TIME_PER_DEGREE.multipliedBy(degreesToRotate);
                    this.ccs.schedule(rotationTime, () -> this.filterState.setState(FilterState.UNLOADED));
                    waitForRotation.get(rotationTime.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    this.currentRotationPosition = targetRotation;
                }
                this.filterState.setState(FilterState.LOADING);
                Future<Void> waitForUnloaded = this.ccs.waitForStatus(FilterState.LOADED);
                this.ccs.schedule(LOAD_TIME, () -> {
                    this.filterState.setState(FilterState.LOADED);
                    this.currentFilter = requestedFilter;
                });
                waitForUnloaded.get(LOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
            }
        }
    }

    short getFilterId() {
        return this.currentFilter.getSerial();
    }

    public static class CCSAvailableFiltersEvent
    extends Event {
        private final List<String> availableFilters;

        public CCSAvailableFiltersEvent(List<String> availableFilters) {
            this.availableFilters = availableFilters;
        }

        public List<String> getAvailableFilters() {
            return this.availableFilters;
        }

        public String toString() {
            return "CCSAvailableFiltersEvent{availableFilters=" + this.availableFilters + '}';
        }
    }

    private static enum InstalledFilter {
        NONE(0),
        U(10),
        G(9),
        R(1),
        I(9),
        X(100);

        private final short serial;

        private InstalledFilter(int serial) {
            this.serial = (short)serial;
        }

        public short getSerial() {
            return this.serial;
        }

        public String toString() {
            if (this == NONE) {
                return super.toString();
            }
            return super.toString().toLowerCase() + "-" + this.serial;
        }
    }

    public static enum FilterState {
        ROTATING,
        UNLOADED,
        LOADED,
        UNLOADING,
        LOADING;

    }
}

