/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.GUILayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.event.AvailableFiltersEvent;

public class StandaloneOCSGUI {
    private static final Logger logger = Logger.getLogger(StandaloneOCSGUI.class.getName());

    public static void main(String[] args) {
        OCSBridgeConfig.Device device = OCSBridgeConfig.Device.CAMERA;
        if (args.length > 0) {
            device = OCSBridgeConfig.Device.valueOf(args[0]);
        }
        SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr = OCSBridgeConfig.createSALManager(device);
        CCS ccs = new CCS();
        GUISALLayer guisalLayer = new GUISALLayer(mgr, ccs);
        ToyOCSGUI gui = new ToyOCSGUI(guisalLayer, device);
        gui.setVisible(true);
        guisalLayer.start();
    }

    private static class GUISALLayer
    implements GUILayer {
        private final SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr;
        private final CCS ccs;

        public GUISALLayer(SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr, CCS ccs) {
            this.mgr = mgr;
            this.ccs = ccs;
        }

        public void start() {
            Thread eventThread = new Thread("SALEventReceiver"){

                @Override
                public void run() {
                    try {
                        this.runEventLoop();
                    }
                    catch (Exception x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer for events, check that SAL has been setup correctly.", x);
                    }
                }
            };
            eventThread.start();
        }

        @Override
        public void execute(CameraCommand cmd) {
            try {
                this.mgr.issueCommand(cmd);
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Exception executing SAL command: {0}", ex.getMessage());
            }
        }

        private void runEventLoop() {
            try {
                while (true) {
                    CameraEvent event;
                    if ((event = this.mgr.getNextEvent(Duration.ofMinutes(1L))) == null) {
                        logger.info("Still waiting for an event");
                        continue;
                    }
                    logger.log(Level.INFO, "Received {0}", event);
                    if (event instanceof CameraStateChangeEvent) {
                        Enum value = ((CameraStateChangeEvent)event).getSubstate().getEnum();
                        this.ccs.getAggregateStatus().add(new State(value));
                        continue;
                    }
                    if (!(event instanceof AvailableFiltersEvent)) continue;
                    List<String> availableFilters = Arrays.asList(((AvailableFiltersEvent)event).getFilterNames().split(":"));
                    this.ccs.fireEvent(new Filter.CCSAvailableFiltersEvent(availableFilters));
                }
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Unexpected exception while waiting for events", ex);
                return;
            }
        }

        private void runTelemetryLoop() {
            try {
                while (true) {
                    CameraTelemetry telemetry;
                    if ((telemetry = this.mgr.getTelemetry(Duration.ofMinutes(1L))) == null) {
                        continue;
                    }
                    logger.log(Level.INFO, "Received {0}", telemetry);
                }
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Unexpected exception while waiting for events", ex);
                return;
            }
        }

        @Override
        public AggregateStatus getAggregateStatus() {
            return this.ccs.getAggregateStatus();
        }

        @Override
        public void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
            this.ccs.addStateChangeListener(listener);
        }

        @Override
        public void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
            this.ccs.removeStateChangeListener(listener);
        }

        @Override
        public void execute(CCSCommand command) {
        }

        @Override
        public boolean supportsCCSCommands() {
            return false;
        }

        @Override
        public void addEventListener(Event.EventListener listener) {
            this.ccs.addEventListener(listener);
        }

        @Override
        public void removeEventListener(Event.EventListener listener) {
            this.ccs.removeEventListener(listener);
        }
    }
}

