/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.CalibrationDetailedStateEvent;
import org.lsst.sal.camera.states.FilterChangerDetailedStateEvent;
import org.lsst.sal.camera.states.ImageReadinessDetailedStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.RaftsDetailedStateEvent;
import org.lsst.sal.camera.states.ShutterDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSBridgeSALLayer
extends OCSCommandExecutor {
    private final OCSBridge bridge;
    private final SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr;
    private boolean shutdown = false;
    private static final Logger logger = Logger.getLogger(OCSBridgeSALLayer.class.getName());
    private Thread runThread;
    private SALReceivedCommand<CameraCommand> currentCommand;

    OCSBridgeSALLayer(OCSBridge bridge) {
        super(bridge);
        this.bridge = bridge;
        this.mgr = bridge.getConfig().getSALManager();
        bridge.getCCS().addStateChangeListener((currentState, oldState) -> {
            int priority = 1;
            try {
                if (currentState instanceof SummaryStateEvent.LSE209State) {
                    this.mgr.logEvent(new SummaryStateEvent(priority, (SummaryStateEvent.LSE209State)currentState));
                } else if (currentState instanceof Shutter.ShutterState) {
                    this.mgr.logEvent(new ShutterDetailedStateEvent(priority, ShutterDetailedStateEvent.ShutterState.values()[currentState.ordinal()]));
                } else if (currentState instanceof CCSCommandStateEvent.IdleBusyState) {
                    this.mgr.logEvent(new CCSCommandStateEvent(priority, (CCSCommandStateEvent.IdleBusyState)currentState));
                } else if (currentState instanceof Filter.FilterState) {
                    this.mgr.logEvent(new FilterChangerDetailedStateEvent(priority, FilterChangerDetailedStateEvent.FilterChangerState.values()[currentState.ordinal()]));
                } else if (currentState instanceof MCM.TakeImageReadinessState) {
                    this.mgr.logEvent(new ImageReadinessDetailedStateEvent(priority, ImageReadinessDetailedStateEvent.ImageReadinessState.values()[currentState.ordinal()]));
                } else if (currentState instanceof Rafts.RaftsState) {
                    this.mgr.logEvent(new RaftsDetailedStateEvent(priority, RaftsDetailedStateEvent.RaftsState.values()[currentState.ordinal()]));
                } else if (currentState instanceof MCM.CalibrationState) {
                    this.mgr.logEvent(new CalibrationDetailedStateEvent(priority, CalibrationDetailedStateEvent.CalibrationState.values()[currentState.ordinal()]));
                } else if (currentState instanceof OfflineDetailedStateEvent.OfflineState) {
                    this.mgr.logEvent(new OfflineDetailedStateEvent(priority, (OfflineDetailedStateEvent.OfflineState)currentState));
                }
            }
            catch (SALException x) {
                logger.log(Level.SEVERE, "Unable to log message", x);
            }
        });
        bridge.getCCS().addEventListener(event -> {
            int priority = 1;
            try {
                if (event instanceof Filter.CCSAvailableFiltersEvent) {
                    this.mgr.logEvent(new AvailableFiltersEvent(priority, String.join((CharSequence)":", ((Filter.CCSAvailableFiltersEvent)event).getAvailableFilters())));
                }
            }
            catch (SALException x) {
                logger.log(Level.SEVERE, "Unable to log message", x);
            }
        });
    }

    public void start() {
        Thread t = new Thread("SALCommandReceiver"){

            @Override
            public void run() {
                try {
                    OCSBridgeSALLayer.this.runCommandLoop();
                }
                catch (Exception x) {
                    logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                }
            }
        };
        t.start();
    }

    private void runCommandLoop() {
        try {
            this.runThread = Thread.currentThread();
            while (!this.shutdown) {
                this.currentCommand = this.mgr.getNextCommand(Duration.ofMinutes(1L));
                if (this.currentCommand == null) {
                    logger.info("Still waiting for a command");
                    continue;
                }
                this.bridge.execute(this.currentCommand.getCommand());
            }
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while waiting for commands", ex);
        }
        finally {
            this.runThread = null;
        }
    }

    private void shutdown() throws InterruptedException {
        this.shutdown = true;
        this.runThread.join();
    }

    @Override
    protected void reportComplete(OCSCommandExecutor.OCSExecutor command) {
        super.reportComplete(command);
        try {
            this.currentCommand.reportComplete();
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void reportError(OCSCommandExecutor.OCSExecutor command, Exception ex) {
        super.reportError(command, ex);
        try {
            this.currentCommand.reportError(ex);
        }
        catch (SALException x) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", x);
        }
    }

    @Override
    protected void acknowledgeCommand(OCSCommandExecutor.OCSExecutor command, Duration timeout) {
        super.acknowledgeCommand(command, timeout);
        try {
            this.currentCommand.acknowledgeCommand(timeout);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void rejectCommand(OCSCommandExecutor.OCSExecutor command, String reason) {
        super.rejectCommand(command, reason);
        try {
            this.currentCommand.rejectCommand(reason);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    void sendEvent(CameraEvent event) {
        super.sendEvent(event);
        try {
            this.mgr.logEvent(event);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending event to SAL", ex);
        }
    }

    @Override
    void sendTelemetry(CameraTelemetry telemetry) {
        try {
            this.mgr.sendTelemetry(telemetry);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending telemetry to SAL", ex);
        }
    }
}

