/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.GUIDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRaftIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;
import org.lsst.sal.camera.telemetry.CameraFilterTelemetry;

public class OCSBridge {
    private static final Logger LOG = Logger.getLogger(OCSBridge.class.getName());
    private final CCS ccs;
    private final State lse209State;
    private final State offlineState;
    private OCSCommandExecutor ocsCommandExecutor;
    private CCSCommandExecutor ccsCommandExecutor;
    private final MCMLayer mcm;
    private static final int DEFAULT_EVENT_PRIORITY = 1;
    private BlockingQueue<MCM.CCSImageNameEvent> imageNameTransfer = new ArrayBlockingQueue<MCM.CCSImageNameEvent>(1);
    private MCM.CCSImageNameEvent imageNameEvent;
    private CCSTimeStamp ccsTimeStamp;
    private final OCSBridgeConfig config;
    private final State commandState;

    OCSBridge(OCSBridgeConfig config, CCS ccs, MCMLayer mcm) {
        this.config = config;
        this.ccs = ccs;
        this.mcm = mcm;
        this.lse209State = new State<SummaryStateEvent.LSE209State>(SummaryStateEvent.LSE209State.OFFLINE);
        ccs.getAggregateStatus().add(this.lse209State);
        this.offlineState = new State<OfflineDetailedStateEvent.OfflineState>(OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY);
        ccs.getAggregateStatus().add(this.offlineState);
        this.commandState = new State<CCSCommandStateEvent.IdleBusyState>(CCSCommandStateEvent.IdleBusyState.IDLE);
        ccs.getAggregateStatus().add(this.commandState);
        this.ocsCommandExecutor = new OCSCommandExecutor(this);
        this.ccsCommandExecutor = new CCSCommandExecutor();
        double jitter = 0.2;
        mcm.addStateChangeListener((state, oldState) -> {
            if ((oldState == Rafts.RaftsState.CLEARING || oldState == Rafts.RaftsState.QUIESCENT) && state == Rafts.RaftsState.INTEGRATING) {
                ccs.runInBackground(() -> {
                    try {
                        this.imageNameEvent = this.imageNameTransfer.poll(1L, TimeUnit.SECONDS);
                        if (this.imageNameEvent == null) {
                            throw new RuntimeException("Image name could not be retreived");
                        }
                        this.ocsCommandExecutor.sendEvent(new StartRaftIntegrationEvent(1, this.imageNameEvent.getImageSequenceName(), this.imageNameEvent.getImagesInSequence(), this.imageNameEvent.getImageName(), this.imageNameEvent.getSequenceNumber(), 1000.0 * (double)this.imageNameEvent.getIntegrationStartTime(), this.imageNameEvent.getExposureTime()));
                        this.ocsCommandExecutor.sendEvent(new ImageReadoutParametersEvent(1, this.imageNameEvent.getImageName(), config.ccdNames(), config.ccdType(), config.overRows(), config.overCols(), config.readRows(), config.readCols(), config.readCols2(), config.preCols(), config.preRows(), config.postCols()));
                    }
                    catch (InterruptedException | RuntimeException ex) {
                        LOG.log(Level.SEVERE, "Error sending StartRaftIntegrationEvent", ex);
                    }
                });
            }
            if (oldState == Rafts.RaftsState.INTEGRATING && state == Rafts.RaftsState.READING_OUT) {
                this.ocsCommandExecutor.sendEvent(new StartReadoutEvent(1, this.imageNameEvent.getImageSequenceName(), this.imageNameEvent.getImagesInSequence(), this.imageNameEvent.getImageName(), this.imageNameEvent.getSequenceNumber(), 1000.0 * (double)this.imageNameEvent.getIntegrationStartTime(), this.imageNameEvent.getExposureTime()));
            }
            if (oldState == Rafts.RaftsState.READING_OUT) {
                this.ocsCommandExecutor.sendEvent(new EndReadoutEvent(1, this.imageNameEvent.getImageSequenceName(), this.imageNameEvent.getImagesInSequence(), this.imageNameEvent.getImageName(), this.imageNameEvent.getSequenceNumber(), 1000.0 * (double)this.imageNameEvent.getIntegrationStartTime(), this.imageNameEvent.getExposureTime()));
                ccs.schedule(Duration.ofMillis(300L), new Runnable(){
                    private MCM.CCSImageNameEvent event;
                    {
                        this.event = OCSBridge.this.imageNameEvent;
                    }

                    @Override
                    public void run() {
                        OCSBridge.this.ocsCommandExecutor.sendEvent(new EndOfImageTelemetryEvent(1, this.event.getImageSequenceName(), OCSBridge.this.imageNameEvent.getImagesInSequence(), this.event.getImageName(), this.event.getSequenceNumber(), 1000.0 * (double)this.event.getIntegrationStartTime(), this.event.getExposureTime()));
                    }
                });
            }
            if (oldState == Shutter.ShutterState.CLOSED && state == Shutter.ShutterState.OPENING) {
                this.ocsCommandExecutor.sendEvent(new StartShutterOpenEvent(1));
            }
            if (oldState == Shutter.ShutterState.OPENING && state == Shutter.ShutterState.OPEN) {
                this.ocsCommandExecutor.sendEvent(new EndShutterOpenEvent(1));
            }
            if (oldState == Shutter.ShutterState.OPEN && state == Shutter.ShutterState.CLOSING) {
                this.ocsCommandExecutor.sendEvent(new StartShutterCloseEvent(1));
            }
            if (oldState == Shutter.ShutterState.CLOSING && state == Shutter.ShutterState.CLOSED) {
                this.ocsCommandExecutor.sendEvent(new EndShutterCloseEvent(1));
                this.ocsCommandExecutor.sendEvent(new ShutterMotionProfileEvent(1, this.imageNameEvent.getExposureTime() + jitter));
            }
            if (oldState == Filter.FilterState.UNLOADED && state == Filter.FilterState.ROTATING) {
                this.ocsCommandExecutor.sendEvent(new StartRotateCarouselEvent(1));
            }
            if (oldState == Filter.FilterState.ROTATING && state == Filter.FilterState.UNLOADED) {
                this.ocsCommandExecutor.sendEvent(new EndRotateCarouselEvent(1));
            }
            if (oldState == Filter.FilterState.UNLOADED && state == Filter.FilterState.LOADING) {
                this.ocsCommandExecutor.sendEvent(new StartLoadFilterEvent(1));
            }
            if (oldState == Filter.FilterState.LOADING && state == Filter.FilterState.LOADED) {
                this.ocsCommandExecutor.sendEvent(new EndLoadFilterEvent(1));
            }
            if (oldState == Filter.FilterState.LOADED && state == Filter.FilterState.UNLOADING) {
                this.ocsCommandExecutor.sendEvent(new StartUnloadFilterEvent(1));
            }
            if (oldState == Filter.FilterState.UNLOADING && state == Filter.FilterState.UNLOADED) {
                this.ocsCommandExecutor.sendEvent(new EndUnloadFilterEvent(1));
            }
        });
        mcm.addEventListener(event -> {
            if (event instanceof Filter.CCSAvailableFiltersEvent) {
                List<String> filters = ((Filter.CCSAvailableFiltersEvent)event).getAvailableFilters();
                this.ocsCommandExecutor.sendEvent(new AvailableFiltersEvent(1, String.join((CharSequence)":", filters)));
            } else if (event instanceof MCM.CCSImageNameEvent) {
                this.imageNameTransfer.add((MCM.CCSImageNameEvent)event);
            } else if (event instanceof MCM.CCSSetFilterEvent) {
                MCM.CCSSetFilterEvent setFilter = (MCM.CCSSetFilterEvent)event;
                if (setFilter.isStart()) {
                    this.ocsCommandExecutor.sendEvent(new StartSetFilterEvent(1, setFilter.getFilterName()));
                } else {
                    this.ocsCommandExecutor.sendEvent(new EndSetFilterEvent(1, setFilter.getFilterName()));
                }
            } else if (event instanceof MCM.CCSFilterTelemetry) {
                this.ocsCommandExecutor.sendTelemetry(new CameraFilterTelemetry(((MCM.CCSFilterTelemetry)event).getFilterId()));
            } else if (event instanceof MCM.CCSSettingsAppliedEvent) {
                this.ocsCommandExecutor.sendEvent(new SettingsAppliedEvent(1, ((MCM.CCSSettingsAppliedEvent)event).getSettings(), ((MCM.CCSSettingsAppliedEvent)event).getTimeStamp()));
            }
        });
    }

    State<CCSCommandStateEvent.IdleBusyState> getCommandState() {
        return this.commandState;
    }

    public OCSBridgeConfig getConfig() {
        return this.config;
    }

    void setOCSCommandExecutor(OCSCommandExecutor ocs) {
        this.ocsCommandExecutor = ocs;
    }

    void setCCSCommandExecutor(CCSCommandExecutor ccs) {
        this.ccsCommandExecutor = ccs;
    }

    public static void main(String[] args) {
        OCSBridge ocs = OCSBridge.createOCSBridge();
        ToyOCSGUI gui = new ToyOCSGUI(new GUIDirectLayer(ocs), ocs.getConfig().getDevice());
        gui.setVisible(true);
    }

    static OCSBridge createOCSBridge() {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = MCMConfig.createDefaultConfig();
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig);
    }

    static OCSBridge createOCSBridge(OCSBridgeConfig config, MCMConfig mcmConfig) {
        CCS ccs = new CCS();
        MCMDirectLayer mcm = new MCMDirectLayer(new MCM(ccs, mcmConfig));
        return new OCSBridge(config, ccs, mcm);
    }

    void execute(CameraCommand cmd) {
        if (cmd instanceof SetFilterCommand) {
            this.execute((SetFilterCommand)cmd);
        } else if (cmd instanceof TakeImagesCommand) {
            this.execute((TakeImagesCommand)cmd);
        } else if (cmd instanceof InitImageCommand) {
            this.execute((InitImageCommand)cmd);
        } else if (cmd instanceof EnableCommand) {
            this.execute((EnableCommand)cmd);
        } else if (cmd instanceof DisableCommand) {
            this.execute((DisableCommand)cmd);
        } else if (cmd instanceof ExitControlCommand) {
            this.execute((ExitControlCommand)cmd);
        } else if (cmd instanceof EnterControlCommand) {
            this.execute((EnterControlCommand)cmd);
        } else if (cmd instanceof StartCommand) {
            this.execute((StartCommand)cmd);
        } else if (cmd instanceof StandbyCommand) {
            this.execute((StandbyCommand)cmd);
        } else if (cmd instanceof DiscardRowsCommand) {
            this.execute((DiscardRowsCommand)cmd);
        } else if (cmd instanceof ClearCommand) {
            this.execute((ClearCommand)cmd);
        } else if (cmd instanceof EndImageCommand) {
            this.execute((EndImageCommand)cmd);
        } else if (cmd instanceof StartImageCommand) {
            this.execute((StartImageCommand)cmd);
        } else if (cmd instanceof EnableCalibrationCommand) {
            this.execute((EnableCalibrationCommand)cmd);
        } else if (cmd instanceof DisableCalibrationCommand) {
            this.execute((DisableCalibrationCommand)cmd);
        } else {
            throw new RuntimeException("Unrecognized command " + cmd);
        }
    }

    void execute(InitImageCommand command) {
        InitImageExecutor initImage = new InitImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(initImage);
    }

    void execute(SetFilterCommand command) {
        SetFilterExecutor setFilter = new SetFilterExecutor(command);
        this.ocsCommandExecutor.executeCommand(setFilter);
    }

    void execute(TakeImagesCommand command) {
        TakeImagesExecutor takeImages = new TakeImagesExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeImages);
    }

    void execute(InitGuidersCommand command) {
        InitGuidersExecutor initGuiders = new InitGuidersExecutor(command);
        this.ocsCommandExecutor.executeCommand(initGuiders);
    }

    void execute(DiscardRowsCommand command) {
        DiscardRowsExecutor discardRows = new DiscardRowsExecutor(command);
        this.ocsCommandExecutor.executeCommand(discardRows);
    }

    void execute(ClearCommand command) {
        ClearExecutor clear = new ClearExecutor(command);
        this.ocsCommandExecutor.executeCommand(clear);
    }

    void execute(StartImageCommand command) {
        StartImageExecutor startImage = new StartImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(startImage);
    }

    void execute(EndImageCommand command) {
        EndImageExecutor endImage = new EndImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(endImage);
    }

    void execute(EnterControlCommand command) {
        EnterControlExecutor takeControl = new EnterControlExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeControl);
    }

    void execute(ExitControlCommand command) {
        ExitExecutor exit = new ExitExecutor(command);
        this.ocsCommandExecutor.executeCommand(exit);
    }

    void execute(StartCommand command) {
        StartExecutor start = new StartExecutor(command);
        this.ocsCommandExecutor.executeCommand(start);
    }

    void execute(StandbyCommand command) {
        StandbyExecutor standby = new StandbyExecutor(command);
        this.ocsCommandExecutor.executeCommand(standby);
    }

    void execute(EnableCommand command) {
        EnableExecutor enable = new EnableExecutor(command);
        this.ocsCommandExecutor.executeCommand(enable);
    }

    void execute(DisableCommand command) {
        DisableExecutor disable = new DisableExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(EnableCalibrationCommand command) {
        EnableCalibrationExecutor enableCalibration = new EnableCalibrationExecutor(command);
        this.ocsCommandExecutor.executeCommand(enableCalibration);
    }

    void execute(DisableCalibrationCommand command) {
        DisableCalibrationExecutor disable = new DisableCalibrationExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSSetAvailableCommand) {
            this.execute((CCSCommand.CCSSetAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSRevokeAvailableCommand) {
            this.execute((CCSCommand.CCSRevokeAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSSimulateFaultCommand) {
            this.execute((CCSCommand.CCSSimulateFaultCommand)command);
        } else if (command instanceof CCSCommand.CCSClearFaultCommand) {
            this.execute((CCSCommand.CCSClearFaultCommand)command);
        } else {
            throw new RuntimeException("Unknown command type: " + command);
        }
    }

    void execute(CCSCommand.CCSSetAvailableCommand command) {
        SetAvailableExecutor setAvailable = new SetAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(setAvailable));
    }

    void execute(CCSCommand.CCSRevokeAvailableCommand command) {
        RevokeAvailableExecutor revokeAvailable = new RevokeAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(revokeAvailable));
    }

    void execute(CCSCommand.CCSSimulateFaultCommand command) {
        SimulateFaultExecutor simulateFault = new SimulateFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(simulateFault));
    }

    void execute(CCSCommand.CCSClearFaultCommand command) {
        ClearFaultExecutor clearFault = new ClearFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(clearFault));
    }

    public Future<Void> waitForState(Enum state) {
        return this.ccs.waitForStatus(state);
    }

    CCS getCCS() {
        return this.ccs;
    }

    class ClearFaultExecutor
    extends CCSExecutor {
        private ClearFaultExecutor(CCSCommand.CCSClearFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.FAULT)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY);
        }
    }

    class SimulateFaultExecutor
    extends CCSExecutor {
        private SimulateFaultExecutor(CCSCommand.CCSSimulateFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.FAULT);
        }
    }

    class RevokeAvailableExecutor
    extends CCSExecutor {
        private RevokeAvailableExecutor(CCSCommand.CCSRevokeAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.AVAILABLE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY);
        }
    }

    class SetAvailableExecutor
    extends CCSExecutor {
        private SetAvailableExecutor(CCSCommand.CCSSetAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.AVAILABLE);
        }
    }

    class DisableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public DisableExecutor(DisableCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.ENABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.DISABLED);
        }
    }

    class EnableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnableExecutor(EnableCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.ENABLED);
        }
    }

    class StandbyExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public StandbyExecutor(StandbyCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent(new SettingVersionsEvent(1, "Normal"));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.STANDBY);
        }
    }

    class StartExecutor
    extends ForwardToMCMExecutor {
        public StartExecutor(StartCommand command) {
            super(command, new CCSCommand.CCSStartCommand(command.getConfiguration()), SummaryStateEvent.LSE209State.STANDBY);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.ocsCommandExecutor.sendEvent(new AppliedSettingsMatchStartEvent(1, true));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.DISABLED);
        }
    }

    class ExitExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public ExitExecutor(ExitControlCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.STANDBY)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY);
        }
    }

    class EnterControlExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnterControlExecutor(EnterControlCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.LSE209State.OFFLINE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.AVAILABLE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent(new SettingVersionsEvent(1, "Normal"));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.LSE209State.STANDBY);
        }
    }

    class DiscardRowsExecutor
    extends ForwardToMCMExecutor {
        public DiscardRowsExecutor(DiscardRowsCommand command) {
            super(command, new CCSCommand.CCSDiscardRowsCommand(command.getNRows()));
        }
    }

    class EndImageExecutor
    extends ForwardToMCMExecutor {
        public EndImageExecutor(EndImageCommand command) {
            super(command, new CCSCommand.CCSEndImageCommand());
        }
    }

    class StartImageExecutor
    extends ForwardToMCMExecutor {
        public StartImageExecutor(StartImageCommand command) {
            super(command, new CCSCommand.CCSStartImageCommand(command.getImageSequenceName(), command.isShutter(), command.isScience(), command.isWfs(), command.isGuide(), command.getTimeout()));
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.imageNameTransfer.clear();
            super.execute();
        }
    }

    class ClearExecutor
    extends ForwardToMCMExecutor {
        public ClearExecutor(ClearCommand command) {
            super(command, new CCSCommand.CCSClearCommand(command.getNClears()));
        }
    }

    class InitGuidersExecutor
    extends ForwardToMCMExecutor {
        public InitGuidersExecutor(InitGuidersCommand command) {
            super(command, new CCSCommand.CCSInitGuidersCommand(command.getRoiSpec()));
        }
    }

    class SetFilterExecutor
    extends ForwardToMCMExecutor {
        public SetFilterExecutor(SetFilterCommand command) {
            super(command, new CCSCommand.CCSSetFilterCommand(command.getName()));
        }
    }

    class DisableCalibrationExecutor
    extends ForwardToMCMExecutor {
        public DisableCalibrationExecutor(DisableCalibrationCommand command) {
            super(command, new CCSCommand.CCSDisableCalibrationCommand());
        }
    }

    class EnableCalibrationExecutor
    extends ForwardToMCMExecutor {
        public EnableCalibrationExecutor(EnableCalibrationCommand command) {
            super(command, new CCSCommand.CCSEnableCalibrationCommand());
        }
    }

    class TakeImagesExecutor
    extends ForwardToMCMExecutor {
        public TakeImagesExecutor(TakeImagesCommand command) {
            super(command, new CCSCommand.CCSTakeImagesCommand(command.getExpTime(), command.getNumImages(), command.isShutter(), command.isScience(), command.isWfs(), command.isGuide(), command.getImageSequenceName()));
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.imageNameTransfer.clear();
            super.execute();
        }
    }

    class InitImageExecutor
    extends ForwardToMCMExecutor {
        public InitImageExecutor(InitImageCommand command) {
            super(command, new CCSCommand.CCSInitImageCommand(command.getDeltaT()));
        }
    }

    abstract class ForwardToMCMExecutor
    extends OCSCommandExecutor.OCSExecutor {
        private final CCSCommand ccsCommand;
        private CCSCommand.CCSCommandResponse response;
        private final SummaryStateEvent.LSE209State initialState;

        ForwardToMCMExecutor(CameraCommand command, CCSCommand ccsCommand) {
            this(command, ccsCommand, SummaryStateEvent.LSE209State.ENABLED);
        }

        ForwardToMCMExecutor(CameraCommand command, CCSCommand ccsCommand, SummaryStateEvent.LSE209State initialState) {
            super(command);
            this.ccsCommand = ccsCommand;
            this.initialState = initialState;
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(this.initialState)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in: " + OCSBridge.this.lse209State);
            }
            this.response = OCSBridge.this.mcm.execute(this.ccsCommand);
            CCSCommand.CCSAckOrNack can = this.response.waitForAckOrNack();
            if (can.isNack()) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + can.getReason());
            }
            return can.getDuration();
        }

        @Override
        void execute() throws Exception {
            this.response.waitForCompletion();
        }
    }
}

