/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.main;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.command.ClearCommand;

public class RobsMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws SALException, InterruptedException, ExecutionException, TimeoutException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing arguments");
        }
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try (SALCamera camera = SALCamera.create();){
            switch (args[0]) {
                case "sendCommand": {
                    CameraCommand command = RobsMain.createCommand(args[1], RobsMain.remainingArgs(2, args));
                    SALCommandResponse response = camera.issueCommand(command);
                    response.waitForResponse(Duration.ofSeconds(10L));
                    System.out.println("Response:" + response);
                    return;
                }
                case "receiveCommand": {
                    Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
                    SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
                    result.reportComplete();
                    System.out.println("Result: " + result);
                    return;
                }
                case "sendAndReceiveCommand": {
                    CameraCommand command = RobsMain.createCommand(args[1], RobsMain.remainingArgs(2, args));
                    Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
                    SALCommandResponse response = camera.issueCommand(command);
                    SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
                    result.reportComplete();
                    response.waitForResponse(Duration.ofSeconds(1L));
                    System.out.println("Result: " + result);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unnrecognized action: " + args[0]);
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static CameraCommand createCommand(String command, String[] args) {
        switch (command) {
            case "clear": {
                return new ClearCommand(Integer.parseInt(args[0]));
            }
        }
        throw new IllegalArgumentException("Unrecognized command: " + command);
    }

    private static String[] remainingArgs(int offset, String[] args) {
        String[] result = new String[args.length - offset];
        System.arraycopy(args, offset, result, 0, args.length - offset);
        return result;
    }
}

