/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;

public class StatusDataPublishedByAutochangerSeneca
extends StatusDataPublishedByHardware {
    @DataAttributes(description="Temperature of AC Cell Xminus", units="Celsius")
    private double cellXMinus;
    @DataAttributes(description="Temperature of AC Clamp Motor Xminus", units="Celsius")
    private double clampMotorXMinus;
    @DataAttributes(description="Temperature of AC Clamp Motor Xplus", units="Celsius")
    private double clampMotorXPlus;
    @DataAttributes(description="Temperature of AC Clamp Motor Yminus", units="Celsius")
    private double clampMotorYMinus;
    @DataAttributes(description="Temperature of AC Front Box", units="Celsius")
    private double frontBox;
    @DataAttributes(description="Temperature of AC Linear rail Motor Xminus", units="Celsius")
    private double linearRailMotorXMinus;
    @DataAttributes(description="Temperature of AC Linear rail Motor Xplus", units="Celsius")
    private double linearRailMotorXPlus;
    @DataAttributes(description="Temperature of AC Rear Box", units="Celsius")
    private double rearBox;

    public StatusDataPublishedByAutochangerSeneca(double[] temperatures) {
        for (TempId id : TempId.values()) {
            this.setTemperature(id, temperatures[id.ordinal()]);
        }
    }

    private void setTemperature(TempId id, double value) {
        switch (id) {
            case LINEAR_RAIL_MOTOR_X_PLUS: {
                this.linearRailMotorXPlus = value;
                break;
            }
            case LINEAR_RAIL_MOTOR_X_MINUS: {
                this.linearRailMotorXMinus = value;
                break;
            }
            case CLAMP_MOTOR_X_PLUS: {
                this.clampMotorXPlus = value;
                break;
            }
            case CLAMP_MOTOR_Y_MINUS: {
                this.clampMotorYMinus = value;
                break;
            }
            case CLAMP_MOTOR_X_MINUS: {
                this.clampMotorXMinus = value;
                break;
            }
            case FRONT_BOX: {
                this.frontBox = value;
                break;
            }
            case REAR_BOX: {
                this.rearBox = value;
                break;
            }
            case CELL_X_MINUS: {
                this.cellXMinus = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected TempId: " + id);
            }
        }
    }

    public double getTemperature(int i) {
        if (i < 0 || i >= TempId.values().length) {
            throw new IllegalArgumentException("Temperature index must be between 0 and " + (TempId.values().length - 1) + ", inclusive. Requesting index = " + i);
        }
        TempId id = TempId.values()[i];
        switch (id) {
            case LINEAR_RAIL_MOTOR_X_PLUS: {
                return this.linearRailMotorXPlus;
            }
            case LINEAR_RAIL_MOTOR_X_MINUS: {
                return this.linearRailMotorXMinus;
            }
            case CLAMP_MOTOR_X_PLUS: {
                return this.clampMotorXPlus;
            }
            case CLAMP_MOTOR_Y_MINUS: {
                return this.clampMotorYMinus;
            }
            case CLAMP_MOTOR_X_MINUS: {
                return this.clampMotorXMinus;
            }
            case FRONT_BOX: {
                return this.frontBox;
            }
            case REAR_BOX: {
                return this.rearBox;
            }
            case CELL_X_MINUS: {
                return this.cellXMinus;
            }
        }
        throw new IllegalArgumentException("Unexpected TempId: " + id);
    }

    public static enum TempId {
        LINEAR_RAIL_MOTOR_X_PLUS("Linear Rail Motor Xplus"),
        LINEAR_RAIL_MOTOR_X_MINUS("Linear Rail Motor Xminus"),
        CLAMP_MOTOR_X_PLUS("Clamp Motor Xplus"),
        CLAMP_MOTOR_Y_MINUS("Clamp Motor Yminus"),
        CLAMP_MOTOR_X_MINUS("Clamp Motor Xminus"),
        FRONT_BOX("Front box"),
        REAR_BOX("Rear box"),
        CELL_X_MINUS("Cell Xminus");

        private final String description;

        private TempId(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

