/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.PtpDeviceState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MotionProfileFitterTest {
    @Test
    public void slowFitTest() throws IOException, InterruptedException, ExecutionException {
        String path = "maincamera/MC_O_20250603_000104_shutterMotionProfileOpen.json";
        MotionDone md = MotionProfileFitterTest.readShutterMotionProfile(path);
        System.out.println(md);
        try {
            ShutterMotionProfileFitter fitter = (ShutterMotionProfileFitter)ShutterMotionProfileFitter.fit((Executor)ForkJoinPool.commonPool(), (MotionDone)md).get();
            ShutterMotionProfileFitResult shutterMotionProfileFitResult = fitter.getHallSensorFit();
        }
        catch (ExecutionException x) {
            Assert.assertTrue((boolean)(x.getCause() instanceof TooManyIterationsException));
        }
    }

    @Test
    public void normalFitTest() throws IOException, InterruptedException, ExecutionException {
        String path = "maincamera/MC_O_20250603_000102_shutterMotionProfileOpen.json";
        MotionDone md = MotionProfileFitterTest.readShutterMotionProfile(path);
        System.out.println(md);
        ShutterMotionProfileFitter fitter = (ShutterMotionProfileFitter)ShutterMotionProfileFitter.fit((Executor)ForkJoinPool.commonPool(), (MotionDone)md).get();
        ShutterMotionProfileFitResult hallSensorFit = fitter.getHallSensorFit();
    }

    private static MotionDone readShutterMotionProfile(String path) throws IOException {
        try (InputStream in = ShutterMotionProfileSender.class.getResourceAsStream(path);){
            MotionDone motionDone;
            if (in == null) {
                throw new IOException("Could not open motion profile from " + path);
            }
            try (InputStreamReader reader = new InputStreamReader(in);){
                MotionDone md;
                ObjectMapper mapper = new ObjectMapper();
                HashMap jsonData = (HashMap)mapper.readValue((Reader)reader, HashMap.class);
                System.out.println("Got " + jsonData);
                Map motionProfile = (Map)jsonData.get("motionProfile");
                double startPosition = (Double)motionProfile.get("startPosition");
                double targetPosition = (Double)motionProfile.get("targetPosition");
                double endPosition = (Double)motionProfile.get("endPosition");
                Duration targetDuration = Duration.ofMillis(((Integer)motionProfile.get("targetDuration")).intValue());
                Duration actualDuration = Duration.ofMillis(((Integer)motionProfile.get("actionDuration")).intValue());
                ShutterSide side = ShutterSide.valueOf((String)((String)motionProfile.get("side")));
                boolean isOpen = (Boolean)motionProfile.get("isOpen");
                CCSTimeStamp startTime = MotionProfileFitterTest.fromTAI((Map)motionProfile.get("startTime"));
                ArrayList<HallTransition> hallTransitions = new ArrayList<HallTransition>();
                ArrayList<EncoderSample> encoderSamples = new ArrayList<EncoderSample>();
                PtpDeviceState ptpState = PtpDeviceState.SLAVE;
                int leapSeconds = 37;
                boolean leapIsValid = false;
                List rawEncoderSamples = (List)motionProfile.get("encodeSamples");
                for (Object es : rawEncoderSamples) {
                    double position = (Double)es.get("position");
                    CCSTimeStamp time = MotionProfileFitterTest.fromTAI((Map)es.get("time"));
                    encoderSamples.add(new EncoderSample(time, position));
                }
                List rawHallTransitions = (List)motionProfile.get("hallTransitions");
                for (Map es : rawHallTransitions) {
                    double position = (Double)es.get("position");
                    CCSTimeStamp time = MotionProfileFitterTest.fromTAI((Map)es.get("time"));
                    int sensorId = (Integer)es.get("sensorId");
                    boolean isOn = (Boolean)es.get("isOn");
                    hallTransitions.add(new HallTransition(time, sensorId, position, isOn));
                }
                motionDone = md = new MotionDone.Builder().actualDuration(actualDuration).endPosition(endPosition).encoderSamples(encoderSamples).hallTransitions(hallTransitions).leapIsValid(false).leapSeconds(37).ptpState(ptpState).side(side).startPosition(startPosition).startTime(startTime).targetDuration(targetDuration).targetPosition(targetPosition).build();
            }
            return motionDone;
        }
    }

    private static CCSTimeStamp fromTAI(Map tai) {
        double mjd = (Double)tai.get("mjd");
        double epochSeconds = 86400.0 * (mjd - 2440587.5 + 2400000.5);
        int epochSecond = (int)Math.floor(epochSeconds);
        int nano = (int)Math.floor(1.0E9 * (epochSeconds - (double)epochSecond));
        Instant taiInstant = Instant.ofEpochSecond(epochSecond, nano);
        return CCSTimeStamp.fromTAI((Instant)taiInstant, (int)37);
    }
}

