/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class MeasuredShutterOpenTimeTest {
    @Test
    public void computeMeasuredShutterOpenTimeTest() throws IOException, ClassNotFoundException, InterruptedException, ExecutionException {
        ImageName imageName = new ImageName("MC_C_20240726_000001");
        MotionDone openMotionDone = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-64.ser");
        ShutterMotionProfileFitter openFitResult = (ShutterMotionProfileFitter)ShutterMotionProfileFitter.fit((Executor)ForkJoinPool.commonPool(), (MotionDone)openMotionDone).get();
        ShutterMotionProfileSender openSender = new ShutterMotionProfileSender(imageName, openMotionDone, true, openFitResult);
        ShutterMotionProfileFitResult openHallSensorFitResult = openSender.getHallSensorFitResult();
        double midPointTimeAtOpen = openSender.getStartTime().getTAIDouble() + openSender.getMidPointTimeFromHallSensor() + openHallSensorFitResult.getModelStartTime();
        MotionDone closeMotionDone = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-89.ser");
        ShutterMotionProfileFitter closeFitResult = (ShutterMotionProfileFitter)ShutterMotionProfileFitter.fit((Executor)ForkJoinPool.commonPool(), (MotionDone)closeMotionDone).get();
        ShutterMotionProfileSender closeSender = new ShutterMotionProfileSender(imageName, closeMotionDone, false, closeFitResult);
        ShutterMotionProfileFitResult closeHallSensorFitResult = closeSender.getHallSensorFitResult();
        double midPointTimeAtClose = closeSender.getStartTime().getTAIDouble() + closeSender.getMidPointTimeFromHallSensor() + closeHallSensorFitResult.getModelStartTime();
        double measuredShutterOpenTime = midPointTimeAtClose - midPointTimeAtOpen;
        Assert.assertEquals((double)5.001, (double)measuredShutterOpenTime, (double)0.001);
    }
}

