/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.subsystem.ocsbridge.HeaderServiceEventHandler;

public class HeaderServiceEventHandlerTest {
    @Test
    public void testEventFired() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.findAndRegisterModules();
        mapper.addMixIn(ImageHeaderData.Header.class, HeaderServiceEventHandler.HeaderMixIn.class);
        URL dataUrl = HeaderServiceEventHandlerTest.class.getResource("data.yaml");
        Assert.assertNotNull((Object)dataUrl);
        TestHeaderServiceEventHandler handler = new TestHeaderServiceEventHandler();
        handler.handleEvent(dataUrl.toString());
        Assert.assertTrue((boolean)handler.wasCalled);
    }

    @Test
    public void testModern() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.findAndRegisterModules();
        mapper.addMixIn(ImageHeaderData.Header.class, HeaderServiceEventHandler.HeaderMixIn.class);
        URL dataUrl = HeaderServiceEventHandlerTest.class.getResource("MTHeaderService_header_MC_O_20250919_000330.yaml");
        Assert.assertNotNull((Object)dataUrl);
        TestModernHeaderServiceEventHandler handler = new TestModernHeaderServiceEventHandler();
        handler.handleEvent(dataUrl.toString());
    }

    @Test
    public void testModernWithNaN() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.findAndRegisterModules();
        mapper.addMixIn(ImageHeaderData.Header.class, HeaderServiceEventHandler.HeaderMixIn.class);
        URL dataUrl = HeaderServiceEventHandlerTest.class.getResource("MTHeaderService_header_MC_O_20251026_000414.yaml");
        Assert.assertNotNull((Object)dataUrl);
        TestModernHeaderServiceEventHandler handler = new TestModernHeaderServiceEventHandler();
        handler.handleEvent(dataUrl.toString());
        Assert.assertTrue((boolean)handler.wasCalled);
    }

    static class TestHeaderServiceEventHandler
    extends HeaderServiceEventHandler {
        boolean wasCalled = false;

        TestHeaderServiceEventHandler() {
        }

        void sendPrimaryHeaderViaCCS(List<ImageHeaderData.Header> data) {
            Assert.assertEquals((Object)"SIMPLE", (Object)data.get(0).getKeyword());
            Assert.assertEquals((Object)true, (Object)data.get(0).getValue());
            Assert.assertEquals((Object)8, (Object)data.get(1).getValue());
            Assert.assertEquals((Object)"LSST DM Header Service", (Object)data.get(4).getValue());
            Assert.assertEquals((Object)"MJD", (Object)data.get(12).getKeyword());
            Assert.assertEquals((double)59241.93473455626, (double)((Double)data.get(12).getValue()), (double)1.0E-12);
            this.wasCalled = true;
        }
    }

    static class TestModernHeaderServiceEventHandler
    extends HeaderServiceEventHandler {
        boolean wasCalled = false;

        TestModernHeaderServiceEventHandler() {
        }

        void sendPrimaryHeaderViaCCS(List<ImageHeaderData.Header> data) {
            Assert.assertEquals((long)117L, (long)data.size());
            int nDouble = 0;
            int nString = 0;
            int nBoolean = 0;
            int nInteger = 0;
            int nNull = 0;
            for (ImageHeaderData.Header datum : data) {
                Object value = datum.getValue();
                if (value == null) {
                    ++nNull;
                    continue;
                }
                if (value instanceof Double) {
                    ++nDouble;
                    continue;
                }
                if (value instanceof String) {
                    ++nString;
                    continue;
                }
                if (value instanceof Boolean) {
                    ++nBoolean;
                    continue;
                }
                if (value instanceof Integer) {
                    ++nInteger;
                    continue;
                }
                throw new RuntimeException(String.format("Unexpected type %s for %s", value.getClass(), datum.getKeyword()));
            }
            Assert.assertEquals((long)38L, (long)nDouble);
            Assert.assertEquals((long)45L, (long)nString);
            Assert.assertEquals((long)2L, (long)nBoolean);
            Assert.assertEquals((long)14L, (long)nInteger);
            Assert.assertEquals((long)18L, (long)nNull);
            this.wasCalled = true;
            try {
                File tempFile = File.createTempFile("headers", ".ser");
                try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(tempFile));){
                    out.writeObject(data);
                }
                System.out.println("Write header data to " + tempFile);
            }
            catch (IOException ex) {
                System.getLogger(HeaderServiceEventHandlerTest.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
            }
        }
    }
}

