/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.states.CameraMotionState;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.mtmount.command.LockMotionCommand;
import org.lsst.sal.mtmount.enumeration.MotionLockState;
import org.lsst.sal.mtmount.states.MotionLockStateEvent;
import org.lsst.sal.mtrotator.command.UnlockMotionCommand;
import org.lsst.sal.mtrotator.event.HeartbeatEvent;
import org.lsst.sal.mtrotator.states.SummaryStateEvent;

public class MotionLockUnlockEventHandler
implements EventListener<SALEvent>,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger(MotionLockUnlockEventHandler.class.getName());
    private SAL<SALCommand, SALEvent, SALTelemetry> rotatorManager;
    private SAL<SALCommand, SALEvent, SALTelemetry> mountManager;
    private MotionLockState mountMotionLockState;
    private org.lsst.sal.mtrotator.enumeration.MotionLockState rotatorMotionLockState;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;

    @Override
    public void eventFired(SALEvent event) {
        if (event instanceof org.lsst.sal.mtmount.states.SummaryStateEvent) {
            org.lsst.sal.mtmount.states.SummaryStateEvent sse = (org.lsst.sal.mtmount.states.SummaryStateEvent)event;
            LOG.log(Level.INFO, "MTMount service state changed {0}", sse);
        } else if (event instanceof SummaryStateEvent) {
            SummaryStateEvent sse = (SummaryStateEvent)event;
            LOG.log(Level.INFO, "MTRotator service state changed {0}", sse);
        } else if (event instanceof org.lsst.sal.mtmount.event.HeartbeatEvent) {
            org.lsst.sal.mtmount.event.HeartbeatEvent heartbeat = (org.lsst.sal.mtmount.event.HeartbeatEvent)event;
            LOG.log(Level.FINE, "MTMount heartbeat {0}", heartbeat);
        } else if (event instanceof HeartbeatEvent) {
            HeartbeatEvent heartbeat = (HeartbeatEvent)event;
            LOG.log(Level.FINE, "MTRotator heartbeat {0}", heartbeat);
        } else if (event instanceof MotionLockStateEvent) {
            MotionLockStateEvent mlse = (MotionLockStateEvent)event;
            LOG.log(Level.INFO, "MTMount MotionLockStateEvent {0}", mlse);
            this.mountMotionLockState = MotionLockState.forSALValue((int)mlse.getLockState());
            this.setMotionLockState();
        } else if (event instanceof org.lsst.sal.mtrotator.states.MotionLockStateEvent) {
            org.lsst.sal.mtrotator.states.MotionLockStateEvent mlse = (org.lsst.sal.mtrotator.states.MotionLockStateEvent)event;
            LOG.log(Level.INFO, "MTRotator MotionLockStateEvent {0}", mlse);
            this.rotatorMotionLockState = org.lsst.sal.mtrotator.enumeration.MotionLockState.forSALValue((int)mlse.getLockState());
            this.setMotionLockState();
        }
    }

    private synchronized void setMotionLockState() {
        boolean locked = this.mountMotionLockState == MotionLockState.LOCKED && this.rotatorMotionLockState == org.lsst.sal.mtrotator.enumeration.MotionLockState.LOCKED;
        this.agentStateService.updateAgentState(new Enum[]{locked ? CameraMotionState.LOCKED : CameraMotionState.UNLOCKED});
    }

    void lock() throws TimeoutException, SALException {
        this.execute("MTRotator", this.rotatorManager, (SALCommand)new org.lsst.sal.mtrotator.command.LockMotionCommand());
        this.execute("MTMount", this.mountManager, (SALCommand)new LockMotionCommand());
    }

    void unlock() throws TimeoutException, SALException {
        this.execute("MTRotator", this.rotatorManager, (SALCommand)new UnlockMotionCommand());
        this.execute("MTMount", this.mountManager, (SALCommand)new org.lsst.sal.mtmount.command.UnlockMotionCommand());
    }

    boolean isLocked() {
        return this.agentStateService.getState(CameraMotionState.class) == CameraMotionState.LOCKED;
    }

    public void execute(String csc, SAL<SALCommand, SALEvent, SALTelemetry> mgr, SALCommand cmd) throws TimeoutException, SALException {
        try {
            LOG.log(Level.INFO, "Sending {0}: {1}", new Object[]{csc, cmd});
            SALCommandResponse response = mgr.issueCommand(cmd);
            Duration estimatedTime = response.waitForAck(Duration.ofSeconds(10L));
            if (estimatedTime != Duration.ZERO) {
                LOG.log(Level.INFO, "Expected command duration {0}", estimatedTime);
            }
            int rc = response.waitForCompletion(estimatedTime.plus(Duration.ofSeconds(10L)));
            LOG.log(Level.INFO, "Command complete ack={0}", rc);
        }
        catch (SALCommandResponse.CommandFailedException ex) {
            LOG.log(Level.SEVERE, "Command failed: errorCode={1}, ack={2}, message={0}", new Object[]{ex.getMessage(), ex.getErrorCode(), ex.getAck()});
            throw ex;
        }
        catch (TimeoutException ex) {
            LOG.log(Level.WARNING, "Timeout while waiting for ack from: {0}", cmd);
            throw ex;
        }
        catch (SALException ex) {
            LOG.log(Level.SEVERE, "Exception executing SAL command: {0}", ex.getMessage());
            throw ex;
        }
    }

    void setManagers(SAL<SALCommand, SALEvent, SALTelemetry> mtRotatorManager, SAL<SALCommand, SALEvent, SALTelemetry> mtMountManager) {
        this.rotatorManager = mtRotatorManager;
        this.mountManager = mtMountManager;
    }
}

