/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitAndTakeImageTest
extends BridgeTest {
    @Test
    public void initAndTake() throws InterruptedException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        TimeUnit.SECONDS.sleep(2L);
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, "", "imageType: mockturtle001, groupId: group", "annotation"));
        TimeUnit.SECONDS.sleep(11L);
        tl.printFinalStates("InitAndTakeImageTest:initAndTake()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitAndTakeImageTest:initAndTake()");
        Assert.assertEquals((Object)CCSCommandStateEvent.CCSCommandState.BUSY, (Object)states.get(0));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterReadinessState.GETTING_READY, ShutterReadinessState.READY, ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{TakeImageReadinessState.GETTING_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{RaftsState.CLEARING, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED, ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED}));
        this.executor.printEventList("InitAndTakeImageTest:initAndTake()");
        Assert.assertTrue((this.executor.getEventCount() >= 16 && this.executor.getEventCount() <= 20 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartIntegrationEvent.class, StartIntegrationEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartReadoutEvent.class, EndReadoutEvent.class, StartReadoutEvent.class, EndReadoutEvent.class));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        ImageName imageName1 = new ImageName(event1.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName1.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName1.getSource());
        Assert.assertEquals((Object)"mockturtle001", (Object)this.getImageType(event1));
        Assert.assertEquals((Object)"group", (Object)this.getGroupId(event1));
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName2.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName2.getSource());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        Assert.assertEquals((Object)"mockturtle001", (Object)this.getImageType(event2));
        Assert.assertEquals((Object)"group", (Object)this.getGroupId(event2));
    }

    @Test
    public void initAndTakeEarly() throws InterruptedException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        TimeUnit.MILLISECONDS.sleep(500L);
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, "", "imageType: mockturtle002, groupId: group", "annotation"));
        TimeUnit.SECONDS.sleep(11L);
        tl.printFinalStates("InitAndTakeImageTest:initAndTakeEarly()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitAndTakeImageTest:initAndTakeEarly()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.executor.printEventList("InitAndTakeImageTest:initAndTakeEarly()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterReadinessState.GETTING_READY, ShutterReadinessState.READY, ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{TakeImageReadinessState.GETTING_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{RaftsState.CLEARING, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED, ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED}));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        ImageName imageName1 = new ImageName(event1.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName1.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName1.getSource());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName2.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName2.getSource());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        System.out.println("Event list " + this.executor.getEventList());
        Assert.assertTrue((this.executor.getEventCount() >= 16 && this.executor.getEventCount() <= 20 ? 1 : 0) != 0);
    }

    private String getImageType(StartIntegrationEvent event) {
        DelimitedStringSplitJoin sj = new DelimitedStringSplitJoin();
        Map zip = sj.zip((CharSequence)event.getAdditionalKeys(), (CharSequence)event.getAdditionalValues());
        return (String)zip.get("imageType");
    }

    private String getGroupId(StartIntegrationEvent event) {
        DelimitedStringSplitJoin sj = new DelimitedStringSplitJoin();
        Map zip = sj.zip((CharSequence)event.getAdditionalKeys(), (CharSequence)event.getAdditionalValues());
        return (String)zip.get("groupId");
    }
}

