/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;

class TestExecutor
extends OCSCommandExecutor {
    private final List<CameraEvent> events = new ArrayList<CameraEvent>();
    private final CCS ccs;

    public TestExecutor(OCSBridge bridge) {
        super(bridge);
        this.ccs = bridge.getCCS();
    }

    protected void reportError(OCSCommandExecutor.OCSExecutor command, Exception ex) {
        super.reportError(command, ex);
        throw new RuntimeException("Error reported from OCS command", ex);
    }

    protected void rejectCommand(OCSCommandExecutor.OCSExecutor command, String reason) {
        super.rejectCommand(command, reason);
        throw new RuntimeException("Rejected OCS command, reason " + reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(CameraEvent event) {
        if (!(event instanceof CameraStateChangeEvent) && !(event instanceof HeartbeatEvent)) {
            List<CameraEvent> list = this.events;
            synchronized (list) {
                this.events.add(event);
                this.events.notifyAll();
            }
            super.sendEvent(event);
        }
    }

    int getEventCount() {
        return this.events.size();
    }

    List<CameraEvent> getEventList() {
        return this.events;
    }

    CameraEvent getEvent(int index) {
        return this.events.get(index);
    }

    void clearEvents() {
        this.events.clear();
    }

    boolean containsInOrder(Class<? extends CameraEvent> ... eventClassesToTest) {
        int storedClassIndex = 0;
        int sizeOfStoredClasses = this.events.size();
        for (Class<? extends CameraEvent> givenEvent : eventClassesToTest) {
            boolean found = false;
            while (storedClassIndex < sizeOfStoredClasses) {
                if (!this.events.get(storedClassIndex).getClass().isAssignableFrom(givenEvent)) {
                    ++storedClassIndex;
                    continue;
                }
                if (!this.events.get(storedClassIndex).getClass().isAssignableFrom(givenEvent)) continue;
                ++storedClassIndex;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Returning false because " + givenEvent.toString() + " not found");
            return false;
        }
        return true;
    }

    <E extends CameraEvent> E getEventOfClass(Class<E> eventClass, int n) {
        for (CameraEvent e : this.events) {
            if (!eventClass.isAssignableFrom(e.getClass())) continue;
            if (n == 0) {
                return (E)e;
            }
            --n;
        }
        return null;
    }

    <E extends CameraEvent> CompletableFuture<E> getFutureEventOfClass(Class<E> eventClass, int n) {
        CompletableFuture future = new CompletableFuture();
        this.ccs.runInBackground(() -> {
            List<CameraEvent> list = this.events;
            synchronized (list) {
                while (true) {
                    Object result;
                    if (future.isCancelled()) {
                        if (!future.isDone()) return;
                    }
                    if ((result = this.getEventOfClass(eventClass, n)) != null) {
                        future.complete(result);
                    }
                    try {
                        this.events.wait(100L);
                    }
                    catch (InterruptedException ex) {
                        future.completeExceptionally(ex);
                        continue;
                    }
                    break;
                }
            }
        });
        return future;
    }

    void printEventList(String testName) {
        System.out.println(" ************************************* ");
        System.out.println(testName + ": List of Events");
        for (int i = 0; i < this.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.getEvent(i));
        }
        System.out.println(" ************************************* ");
    }
}

