/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitGuidersTest
extends BridgeTest {
    private static final String VALID_ROISPEC = "{\"common\":{\"rows\":50,\"cols\":50,\"integrationTimeMillis\":100},\"R22S00\":{\"segment\":10,\"startRow\":100,\"startCol\":200}, \"R22S01\":{\"segment\":10,\"startRow\":100,\"startCol\":200}, \"R22S21\":{\"segment\":10,\"startRow\":100,\"startCol\":200}, \"R22S22\":{\"segment\":10,\"startRow\":100,\"startCol\":200}}";

    @Test
    public void failTest() {
        try {
            this.ocsBridge.execute(new InitGuidersCommand(VALID_ROISPEC));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void invalidROI() {
        try {
            this.enabler.goToEnable(this.ocsBridge);
            this.ocsBridge.execute(new InitGuidersCommand("bollocks"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void initGuiders() throws Exception {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new InitGuidersCommand(VALID_ROISPEC));
        Assert.assertEquals((long)2L, (long)tl.getCalls());
        tl.printFinalStates("InitGuidersTest:initGuiders()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitGuidersTest:initGuiders()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.executor.printEventList("InitGuidersTest:initGuiders()");
    }

    @Test
    public void initGuidersSplit() throws Exception {
        int split = 99;
        String roiSpec1 = VALID_ROISPEC.substring(0, split) + "-";
        String roiSpec2 = VALID_ROISPEC.substring(split);
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new InitGuidersCommand(roiSpec1));
        Assert.assertEquals((long)2L, (long)tl.getCalls());
        this.ocsBridge.execute(new InitGuidersCommand(roiSpec2));
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        tl.printFinalStates("InitGuidersTest:initGuidersSplit()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitGuidersTest:initGuidersSplit()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.executor.printEventList("InitAndTakeImageTest:initGuidersSplit()");
    }
}

