/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.FcsPowerState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.WakeFilterChangerCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.FilterChangerPowerStatusEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class FilterChangeTest
extends BridgeTest {
    @Override
    @Before
    public void setUp() {
        try {
            super.setUp();
            this.enabler.goToEnable(this.ocsBridge);
            Assert.assertTrue((boolean)this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
            Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{FilterState.LOADED, FcsPowerState.LOW_POWER}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void noFilterName() {
        Assert.assertThrows(RuntimeException.class, () -> this.ocsBridge.execute(new SetFilterCommand("")));
    }

    @Test
    public void badFilterName() {
        Assert.assertThrows(RuntimeException.class, () -> this.ocsBridge.execute(new SetFilterCommand("g-6")));
    }

    @Test
    public void badFilterId() {
        Assert.assertThrows(RuntimeException.class, () -> this.ocsBridge.execute(new SetFilterCommand("g_7")));
    }

    @Test
    public void changeToSameFilter() {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("u_24"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeToSameFilter()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)2L, (long)fsh.getStates().size());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertFalse((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.LOADED}));
        this.executor.printEventList("FilterChangeTest:changeToSameFilter()");
        Assert.assertEquals((long)0L, (long)this.executor.getEventList().size());
    }

    @Test
    public void changeFilterAToFilterB() {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("g_6"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeFilterAToFilterB()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FcsPowerState.REGULAR, FilterState.UNLOADING, FilterState.UNLOADED, FilterState.ROTATING, FilterState.UNLOADED, FilterState.LOADED, FcsPowerState.LOW_POWER, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)10L, (long)tl.getCalls());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.LOADED}));
        this.executor.printEventList("FilterChangeTest:changeFilterAToFilterB()");
        Assert.assertEquals((long)10L, (long)this.executor.getEventList().size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(FilterChangerPowerStatusEvent.class, StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class, FilterChangerPowerStatusEvent.class));
    }

    @Test
    public void changeNoneToFilter() {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.execute(new SetFilterCommand("NONE"));
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("r_57"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeNoneToFilter()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FcsPowerState.REGULAR, FilterState.ROTATING, FilterState.UNLOADED, FilterState.LOADING, FilterState.LOADED, FcsPowerState.LOW_POWER, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)8L, (long)tl.getCalls());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.LOADED}));
        this.executor.printEventList("FilterChangeTest:changeNoneToFilter()");
        Assert.assertEquals((long)8L, (long)this.executor.getEventList().size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(FilterChangerPowerStatusEvent.class, StartSetFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class, FilterChangerPowerStatusEvent.class));
    }

    @Test
    public void changeToNoneFilter() {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("NONE"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeNoneToFilter()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FcsPowerState.REGULAR, FilterState.UNLOADING, FilterState.UNLOADED, FcsPowerState.LOW_POWER, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)6L, (long)tl.getCalls());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.UNLOADED}));
        this.executor.printEventList("FilterChangeTest:changeNoneToFilter()");
        Assert.assertEquals((long)6L, (long)this.executor.getEventList().size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(FilterChangerPowerStatusEvent.class, StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, EndSetFilterEvent.class, FilterChangerPowerStatusEvent.class));
    }

    @Test
    public void changeFilterAlreadyWakenUp() throws Exception {
        this.ocsBridge.execute(new WakeFilterChangerCommand(1));
        this.ocsBridge.waitForState((Enum)FcsPowerState.REGULAR).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{FcsPowerState.REGULAR}));
        this.executor.clearEvents();
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new SetFilterCommand("g_6"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeFilterAlreadyWakenUp()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FilterState.UNLOADING, FilterState.UNLOADED, FilterState.ROTATING, FilterState.UNLOADED, FilterState.LOADED, FcsPowerState.LOW_POWER, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)9L, (long)tl.getCalls());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.LOADED}));
        this.executor.printEventList("FilterChangeTest:changeFilterAlreadyWakenUp()");
        Assert.assertEquals((long)9L, (long)this.executor.getEventList().size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class, FilterChangerPowerStatusEvent.class));
    }

    @Test
    public void changeFilterStayUp() throws Exception {
        this.ocsBridge.execute(new WakeFilterChangerCommand(2));
        this.ocsBridge.waitForState((Enum)FcsPowerState.REGULAR).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{FcsPowerState.REGULAR}));
        this.executor.clearEvents();
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new SetFilterCommand("r_57"));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("FilterChangeTest:changeFilterStayUp()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FilterState.UNLOADING, FilterState.UNLOADED, FilterState.ROTATING, FilterState.UNLOADED, FilterState.LOADED, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)8L, (long)tl.getCalls());
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{FilterState.LOADED}));
        this.executor.printEventList("FilterChangeTest:changeFilterStayUp()");
        Assert.assertEquals((long)8L, (long)this.executor.getEventList().size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
    }
}

