/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAvailableFiltersEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerSimulation;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MainCameraFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class FilterChanger {
    private static final Logger LOG = Logger.getLogger(FilterChanger.class.getName());
    private List<String> availableFilters;
    private List<String> installedFilters;
    private final CCS ccs;
    private FilterChangerInterface filterChanger;
    private final MCMConfig config;

    FilterChanger(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.filterChanger = new FilterChangerSimulation(ccs, config);
    }

    public void start(String configName) throws ExecutionException {
        this.filterChanger.start(configName);
        this.availableFilters = this.filterChanger.getAvailableFilters();
        this.installedFilters = this.filterChanger.getInstalledFilters();
        List<String> availableFilterTypes = this.availableFilters.stream().map(f -> this.filterChanger.getFilterType((String)f)).collect(Collectors.toList());
        double maxAngle = this.filterChanger.getMaxAngleForFilterChange();
        double maxFastAngle = this.filterChanger.getMaxAngleForFastFilterChange();
        int n = availableFilterTypes.size();
        double[] slowChangeTime = new double[n];
        double[] fastChangeTime = new double[n];
        for (int i = 0; i < n; ++i) {
            String filter = this.availableFilters.get(i);
            slowChangeTime[i] = this.filterChanger.getDurationForSlowFilterChange(filter).getSeconds();
            fastChangeTime[i] = this.filterChanger.getDurationForFastFilterChange(filter).getSeconds();
        }
        LOG.log(Level.INFO, "Available filters {0}", this.availableFilters);
        this.ccs.fireEvent(new CCSAvailableFiltersEvent(this.availableFilters, availableFilterTypes, maxAngle, maxFastAngle, slowChangeTime, fastChangeTime));
    }

    boolean filterIsAvailable(String filter) {
        return this.availableFilters.contains(filter);
    }

    boolean filterIsInstalled(String filter) {
        return this.installedFilters.contains(filter);
    }

    List<String> getAvailableFilters() {
        return this.availableFilters;
    }

    String getCurrentFilter() throws ExecutionException {
        return this.filterChanger.getCurrentFilter();
    }

    void setFilter(String filter) throws ExecutionException {
        this.filterChanger.setFilter(filter);
    }

    Duration getEstimatedTimeForChange(String filterName) throws ExecutionException {
        return this.filterChanger.getDurationForSlowFilterChange(filterName);
    }

    public void wakeFilterChanger(int mode) throws ExecutionException {
        this.filterChanger.wakeFilterChanger(mode);
    }

    public Duration getEstimatedTimeForPowerMode(int mode) throws ExecutionException {
        return this.filterChanger.getDurationForWakeUp(mode);
    }

    ControlledSubsystem registerMCMSubsystem(MCMSubsystem mcm) {
        ControlledSubsystem controlledSubsystem = this.config.getCameraType() == Camera.MAIN_CAMERA ? new MainCameraFilterChangerSubsystemLayer(mcm, this.ccs, this.config) : new ComCamFilterChangerSubsystemLayer(mcm, this.ccs, this.config);
        this.filterChanger = controlledSubsystem;
        return controlledSubsystem;
    }

    void setTopLevelAgent(Agent agent) {
        if (this.filterChanger instanceof FilterChangerSimulation) {
            ((FilterChangerSimulation)this.filterChanger).setTopLevelAgent(agent);
        }
    }

    void publishDataProviderCurrentData() {
        if (this.filterChanger instanceof FilterChangerSimulation) {
            ((FilterChangerSimulation)this.filterChanger).publishDataProviderCurrentData();
        }
    }
}

