/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

public enum AgentAlerts {
    ClusterAlert("ClusterAlert", "Alert raised when de serialization problems are detected on the buses"),
    ClusterViewAlert("ClusterViewAlert", "Alert raised when there are problems with the Cluster View"),
    RuntimeAlert("RuntimeAlert", "Alert raised when there are problems with the java runtime environment");

    private final String id;
    private final String description;

    private AgentAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return this.getAlert(null);
    }

    public Alert getAlert(Map<String, Object> alertData) {
        Alert a = new Alert(this.id, this.description);
        if (alertData != null) {
            for (Map.Entry<String, Object> e : alertData.entrySet()) {
                a.addAlertData(e.getKey(), (Serializable)e.getValue());
            }
        }
        return a;
    }
}

