/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.testng.Assert;

public class DeriveClassMapFromDictionaryTest {
    private static final Logger LOG = Logger.getLogger(DeriveClassMapFromDictionaryTest.class.getName());
    private final String result = "classMap.put(\"ATCamera_logevent_bonn_shutter_Device_Devices\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_DevicesConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_Device_General\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_Device_Limits\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_LimitsConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_General\", org.lsst.sal.atcamera.event.Bonn_shutter_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_PeriodicTasks_General\", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_PeriodicTasks_timers\", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent.class);\n";

    @Test
    public void mainTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Camera camera = Camera.AUXTEL;
        String result2 = null;
        for (XMLMaker2.SALType type : XMLMaker2.SALType.values()) {
            MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance((Camera)camera, (XMLMaker2.SALType)type);
            for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : xmlConfig.getOrderedListOfDictionaryConfigurations()) {
                String agentName = dictConfig.getAgentName();
                SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(dictConfig, xmlConfig.getMapping());
                Map map = infoMaker.getSALClasses();
                if (!agentName.equals("bonn-shutter") || type != XMLMaker2.SALType.SETTINGS_APPLIED) continue;
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append("classMap.put(\"").append((String)entry.getKey()).append("\", ").append(((Class)entry.getValue()).getName()).append(".class);\n");
                }
                result2 = sb.toString();
            }
        }
        Assert.assertEquals(result2, (String)"classMap.put(\"ATCamera_logevent_bonn_shutter_Device_Devices\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_DevicesConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_Device_General\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_Device_Limits\", org.lsst.sal.atcamera.event.Bonn_shutter_Device_LimitsConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_General\", org.lsst.sal.atcamera.event.Bonn_shutter_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_PeriodicTasks_General\", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent.class);\nclassMap.put(\"ATCamera_logevent_bonn_shutter_PeriodicTasks_timers\", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent.class);\n");
    }
}

