package org.lsst.ccs.subsystem.ocsbridge;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import org.lsst.sal.SALEvent;

/**
 * This class instantiated from groovy
 * @author tonyj
 */
public class WatcherEventHandler implements EventListener<SALEvent>, HasLifecycle {

    private static final Logger LOG = Logger.getLogger(WatcherEventHandler.class.getName());
    
    @Override
    public void eventFired(SALEvent event) {
        if (event instanceof org.lsst.sal.watcher.event.AlarmEvent alarmEvent) {
            LOG.log(Level.INFO, "Watcher service alarm event {0}", alarmEvent);
        } else if (event instanceof org.lsst.sal.watcher.states.SummaryStateEvent sse) {
            LOG.log(Level.INFO, "Watcher service state changed {0}", sse);
        } else if (event instanceof org.lsst.sal.watcher.event.HeartbeatEvent heartbeat) {
            LOG.log(Level.FINE, "Watcher heartbeat {0}", heartbeat);
        } 
    }    
}
