/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.FcsPowerState;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.WakeFilterChangerCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.FilterChangerPowerStatusEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class WakeFilterChangerTest
extends BridgeTest {
    public WakeFilterChangerTest() {
        super(Camera.MAIN_CAMERA);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        try {
            this.enabler.goToEnable(this.ocsBridge);
            Assert.assertTrue((boolean)this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
            Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{FcsPowerState.LOW_POWER}));
        }
        catch (Exception ex) {
            throw new RuntimeException("OCS Bridge could not go to enable");
        }
    }

    @Test
    public void modeZeroTest() throws Exception {
        this.ocsBridge.execute((CameraCommand)new WakeFilterChangerCommand(2));
        this.ocsBridge.waitForState((Enum)FcsPowerState.REGULAR).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{FcsPowerState.REGULAR}));
        this.executor.clearEvents();
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute((CameraCommand)new WakeFilterChangerCommand(0));
        this.ocsBridge.waitForState((Enum)FcsPowerState.LOW_POWER).get(3L, TimeUnit.SECONDS);
        tl.printFinalStates("WakeFilterChangerTest:modeZeroTest()");
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE, FcsPowerState.LOW_POWER}));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("WakeFilterChangerTest:modeZeroTest()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FcsPowerState.LOW_POWER, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        this.executor.printEventList("WakeFilterChangerTest:modeZeroTest()");
        Assert.assertTrue((boolean)this.executor.containsInOrder(FilterChangerPowerStatusEvent.class));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
    }

    @Test
    public void modeOneAndTwoTest() throws Exception {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute((CameraCommand)new WakeFilterChangerCommand(2));
        this.ocsBridge.waitForState((Enum)FcsPowerState.REGULAR).get(5L, TimeUnit.SECONDS);
        tl.printFinalStates("WakeFilterChangerTest:modeTwoTest()");
        Assert.assertTrue((boolean)tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE, FcsPowerState.REGULAR}));
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("WakeFilterChangerTest:modeTwoTest()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FcsPowerState.REGULAR, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        this.executor.printEventList("WakeFilterChangerTest:modeTwoTest()");
        Assert.assertTrue((boolean)this.executor.containsInOrder(FilterChangerPowerStatusEvent.class));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
    }
}

