package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.services.AgentVersionsService;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;

/**
 * Generates the software versions event for SAL
 *
 * @author tonyj
 */
class SoftwareVersionsGenerator {

    private final Agent agent;
    private final OCSBridge ocsBridge;

    SoftwareVersionsGenerator(OCSBridge ocsBridge, Agent agent) {
        this.ocsBridge = ocsBridge;
        this.agent = agent;
    }

    void run(boolean fullVersions) {
        String cscVersion = agent.getAgentInfo().getAgentProperty(AgentVersionsService.AGENT_VERSION);
        
        String subsystemVersions = "";
        if (fullVersions) {
            agent.getMessagingAccess().getAgentPresenceManager().waitForFirstContact(20, TimeUnit.SECONDS);
            List<AgentInfo> connectedAgents = agent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
            subsystemVersions = connectedAgents.stream()
                    .filter((a) -> a.isAgentWorkerOrService())
                    .filter((a) -> !a.equals(agent.getAgentInfo()))
                    .map((a) -> a.getName() + "=" + a.getAgentProperty(AgentVersionsService.AGENT_VERSION))
                    .collect(Collectors.joining(","));
        }

        OCSCommandExecutor oce = ocsBridge.getOcsCommandExecutor();
        SoftwareVersionsEvent sve = new SoftwareVersionsEvent(oce.getSALVersion(), oce.getXMLVersion(), cscVersion, subsystemVersions);

        ocsBridge.getOcsCommandExecutor().sendEvent(sve);
    }
}
