/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MainCameraFilterChangerSubsystemLayer
extends ControlledSubsystem
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(ComCamFilterChangerSubsystemLayer.class.getName());
    private static final Map<FcsEnumerations.McmFilterState, FilterState> FCS_TO_FILTER_STATE = new HashMap<FcsEnumerations.McmFilterState, FilterState>();
    private volatile CCSSetFilterEvent ccsSetFilterEvent;
    private String previousFilter = "";
    private static final FilterStateConverter converter;

    private FilterState convertState(FcsEnumerations.McmFilterState state) {
        return converter.convertState(state);
    }

    public MainCameraFilterChangerSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFilterChangerSubsystemName(), ccs, config);
    }

    @Override
    public void setFilter(String filter) throws ExecutionException {
        this.previousFilter = this.getCurrentFilter();
        if (this.previousFilter.equals(filter)) {
            return;
        }
        this.ccsSetFilterEvent = new CCSSetFilterEvent(filter, this.getFilterType(filter));
        this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
        LOG.log(Level.INFO, "Sent: {0}", this.ccsSetFilterEvent);
        Duration timeout = this.getDurationForSlowFilterChange(filter);
        if ("NONE".equals(filter)) {
            this.commandSender.sendCommand(Void.TYPE, timeout, "setNoFilter", new Object[0]);
            this.waitUntilMoveComplete(FilterState.NOFILTER, timeout);
        } else {
            if (filter.contains("_")) {
                filter = filter.split("_")[0];
            }
            this.commandSender.sendCommand(Void.TYPE, timeout, "setFilterByName", filter);
            this.waitUntilMoveComplete(FilterState.LOADED, timeout);
        }
    }

    @Override
    public List<String> getAvailableFilters() throws ExecutionException {
        return this.commandSender.sendCommand(List.class, "getAvailableFilters", new Object[0]);
    }

    @Override
    public List<String> getInstalledFilters() throws ExecutionException {
        return this.commandSender.sendCommand(List.class, "getInstalledFilters", new Object[0]);
    }

    @Override
    public String getCurrentFilter() throws ExecutionException {
        return this.commandSender.sendCommand(String.class, "getOnlineFilterName", new Object[0]);
    }

    @Override
    public double getMaxAngleForFilterChange() throws ExecutionException {
        return this.commandSender.sendCommand(Double.class, "getMaxAngleForFilterChange", new Object[0]);
    }

    @Override
    public double getMaxAngleForFastFilterChange() throws ExecutionException {
        return this.commandSender.sendCommand(Double.class, "getMaxAngleForFastFilterChange", new Object[0]);
    }

    @Override
    public Duration getDurationForSlowFilterChange(String filterName) throws ExecutionException {
        return this.commandSender.sendCommand(Duration.class, "getDurationForSlowFilterChange", filterName);
    }

    @Override
    public Duration getDurationForFastFilterChange(String filterName) throws ExecutionException {
        return this.commandSender.sendCommand(Duration.class, "getDurationForFastFilterChange", filterName);
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Filter changer connected");
        FcsEnumerations.FilterState state = (FcsEnumerations.FilterState)initialState.getState(FcsEnumerations.FilterState.class);
        LOG.log(Level.INFO, "Got initial FCS FilterState {0}", state);
        FcsEnumerations.McmFilterState mcmState = (FcsEnumerations.McmFilterState)initialState.getState(FcsEnumerations.McmFilterState.class);
        LOG.log(Level.INFO, "Got initial FCS McmFilterState {0}", mcmState);
        FcsEnumerations.AutochangerInclinationState inclinationState = (FcsEnumerations.AutochangerInclinationState)initialState.getState(FcsEnumerations.AutochangerInclinationState.class);
        LOG.log(Level.INFO, "Got initial FCS AutochangerInclinationState {0}", inclinationState);
        this.translateFcsStateToFilterState(CCSTimeStamp.currentTime(), mcmState, null);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Filter changer disconnected");
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        CCSTimeStamp when = statusChange.getStateTransitionTimestamp();
        StateBundle changedStates = newStates.diffState(oldStates);
        String cause = statusChange.getCause();
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> {
            if (!(value instanceof FcsEnumerations.FilterState)) {
                if (value instanceof FcsEnumerations.McmFilterState) {
                    LOG.log(Level.INFO, "Got McmFilterState {0}", value);
                    this.translateFcsStateToFilterState(when, (FcsEnumerations.McmFilterState)value, cause);
                } else if (value instanceof FcsEnumerations.AutochangerInclinationState) {
                    LOG.log(Level.INFO, "Got AutochangerInclinationState {0}", value);
                }
            }
        });
    }

    private void waitUntilMoveComplete(FilterState finalState, Duration estimatedDurationForFilterChange) throws ExecutionException {
        CompletableFuture<Void> waitForStatus = this.ccs.waitForStatus((Enum)finalState);
        try {
            waitForStatus.get(estimatedDurationForFilterChange.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for filter change to complete", ex);
        }
    }

    private void translateFcsStateToFilterState(CCSTimeStamp when, FcsEnumerations.McmFilterState value, String cause) {
        if (value == null) {
            value = FcsEnumerations.McmFilterState.LOADED;
        }
        FilterState converted = this.convertState(value);
        LOG.log(Level.INFO, "FilterState was converted to {0} ", converted);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<FilterState>(converted, cause));
        }
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        Serializable data = msg.getObject();
        if (data instanceof KeyValueData) {
            KeyValueData sentData = (KeyValueData)data;
            String dataKey = sentData.getKey();
            LOG.log(Level.FINE, "Got kvd {0} {1}", new Object[]{dataKey, sentData.getValue()});
            if (!"fcs/mcm".equals(dataKey)) {
                return;
            }
            KeyValueDataList kvdl = (KeyValueDataList)sentData.getValue();
            String filterName = null;
            String filterType = null;
            int slot = 0;
            int position = 0;
            int percentage = 0;
            double proximity = 0.0;
            FcsEnumerations.AutochangerTrucksState location = FcsEnumerations.AutochangerTrucksState.ONLINE;
            for (KeyValueData kvd : kvdl) {
                Serializable value = kvd.getValue();
                switch (kvd.getKey()) {
                    case "filter_on_autochanger": {
                        filterName = value.toString();
                        filterType = this.getFilterType(filterName);
                        break;
                    }
                    case "filter_previous_socketID": {
                        slot = ((Number)value).intValue();
                        break;
                    }
                    case "autochanger_trucks_position": {
                        position = ((Number)value).intValue();
                        break;
                    }
                    case "autochanger_trucks_state": {
                        location = FcsEnumerations.AutochangerTrucksState.valueOf((String)value.toString());
                        break;
                    }
                    case "setFilter_percentage": {
                        percentage = ((Number)value).intValue();
                        break;
                    }
                    case "proximity": {
                        proximity = ((Number)value).doubleValue();
                    }
                }
            }
            boolean endOfExchange = location == FcsEnumerations.AutochangerTrucksState.ONLINE;
            boolean isSameFilter = this.previousFilter.equals(filterName);
            if (endOfExchange && !isSameFilter) {
                this.ccsSetFilterEvent = new CCSSetFilterEvent(filterName, filterType, slot, proximity == 0.0 ? (double)position : proximity);
                this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
                LOG.log(Level.INFO, "Sent: {0}", this.ccsSetFilterEvent);
            }
        }
    }

    @Override
    protected void onRepublishServiceData() {
        if (this.ccsSetFilterEvent != null) {
            this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
            LOG.log(Level.INFO, "Resent: {0}", this.ccsSetFilterEvent);
        }
    }

    static {
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.LOADING, FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.UNLOADING, FilterState.UNLOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.LOADED, FilterState.LOADED);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.NOFILTER, FilterState.NOFILTER);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.ROTATING, FilterState.ROTATING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmFilterState.UNKNOWN, FilterState.UNKNOWN);
        converter = new FilterStateConverter();
    }

    private static class FilterStateConverter {
        private FilterStateConverter() {
        }

        private FilterState convertStateInstantaneous(FcsEnumerations.McmFilterState state) {
            FilterState s = FCS_TO_FILTER_STATE.get(state);
            if (s == null) {
                s = FilterState.LOADED;
            }
            return s;
        }

        FilterState convertState(FcsEnumerations.McmFilterState state) {
            FilterState s = this.convertStateInstantaneous(state);
            return s;
        }
    }
}

