/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.time.Duration;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.kafka.SALKafkaAck;
import org.lsst.sal.kafka.SALKafkaCommandResponse;
import org.lsst.sal.kafka.SALKafkaObject;
import org.lsst.sal.kafka.SALKafkaSALFileReader;
import org.lsst.sal.kafka.SALKafkaUtils;

public class SALKafkaImplementation<C extends SALCommand, E extends SALEvent, T extends SALTelemetry>
implements SAL<C, E, T> {
    private static final Logger LOGGER = Logger.getLogger(SALKafkaImplementation.class.getName());
    private static final String DEFAULT_LSST_KAFKA_BROKER_ADDR = "localhost:9092";
    private static final String DEFAULT_LSST_SCHEMA_REGISTRY_URL = "http://localhost:8081";
    private static final String DEFAULT_LSST_TOPIC_SUBNAME = "Testing";
    private static final String KAFKA_SERVER_ADDRESS = SALKafkaImplementation.getEnvOrDefault("LSST_KAFKA_BROKER_ADDR", "localhost:9092");
    private static final String SCHEMA_REGISTRY_SERVER_URL = SALKafkaImplementation.getEnvOrDefault("LSST_SCHEMA_REGISTRY_URL", "http://localhost:8081");
    private static final String LSST_TOPIC_SUBNAME = SALKafkaImplementation.getEnvOrDefault("LSST_TOPIC_SUBNAME", "Testing");
    private static final String TOPIC_NAME = "lsst." + LSST_TOPIC_SUBNAME;
    private static final String LSST_SECURITY_PROTOCOL = SALKafkaImplementation.getEnvOrDefault("LSST_SECURITY_PROTOCOL", "PLAINTEXT");
    private static final String LSST_SASL_USERNAME = SALKafkaImplementation.getEnvOrDefault("LSST_SASL_USERNAME", "");
    private static final String LSST_SASL_PASSWORD = SALKafkaImplementation.getEnvOrDefault("LSST_SASL_PASSWORD", "");
    private final Producer<String, GenericRecord> producer;
    private final KafkaConsumerThread consumer_thread;
    private final BlockingQueue<SALReceivedCommand> commandQueue = new LinkedBlockingQueue<SALReceivedCommand>();
    private final BlockingQueue<E> eventQueue = new LinkedBlockingQueue();
    private final BlockingQueue<T> telemetryQueue = new LinkedBlockingQueue<T>();
    private final SALKafkaSALFileReader salFile;
    private final SALKafkaUtils utils = SALKafkaUtils.instance();
    private final String agentName;

    private static String getEnvOrDefault(String env, String defaultValue) {
        String result = System.getenv(env);
        return result == null ? defaultValue : result;
    }

    public SALKafkaImplementation(Class c, String resource, Properties agentProperties) {
        this.salFile = new SALKafkaSALFileReader(c, resource);
        this.agentName = agentProperties.getProperty("AGENT_NAME", "Unknown");
        String agentUUID = agentProperties.getProperty("AGENT_UUID");
        if (agentUUID == null) {
            agentUUID = UUID.randomUUID().toString();
        }
        Properties kafkaProducerProperties = new Properties();
        kafkaProducerProperties.put("bootstrap.servers", KAFKA_SERVER_ADDRESS);
        kafkaProducerProperties.put("key.serializer", StringSerializer.class);
        kafkaProducerProperties.put("value.serializer", KafkaAvroSerializer.class);
        kafkaProducerProperties.put("schema.registry.url", SCHEMA_REGISTRY_SERVER_URL);
        kafkaProducerProperties.put("security.protocol", LSST_SECURITY_PROTOCOL);
        kafkaProducerProperties.put("sasl.mechanism", "SCRAM-SHA-512");
        kafkaProducerProperties.put("sasl.jaas.config", "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + LSST_SASL_USERNAME + "\" password=\"" + LSST_SASL_PASSWORD + "\";");
        kafkaProducerProperties.put("acks", "all");
        kafkaProducerProperties.put("client.id", this.salFile.getCscName() + "_" + this.agentName + "_" + agentUUID);
        this.producer = new KafkaProducer(kafkaProducerProperties);
        Properties kafkaConsumerProperties = new Properties();
        kafkaConsumerProperties.put("bootstrap.servers", KAFKA_SERVER_ADDRESS);
        kafkaConsumerProperties.put("key.deserializer", StringDeserializer.class);
        kafkaConsumerProperties.put("value.deserializer", KafkaAvroDeserializer.class);
        kafkaConsumerProperties.put("schema.registry.url", SCHEMA_REGISTRY_SERVER_URL);
        kafkaConsumerProperties.put("auto.offset.reset", "latest");
        kafkaConsumerProperties.put("enable.auto.commit", (Object)false);
        kafkaConsumerProperties.put("group.id", this.salFile.getCscName() + "_" + this.agentName + "_" + agentUUID);
        kafkaConsumerProperties.put("security.protocol", LSST_SECURITY_PROTOCOL);
        kafkaConsumerProperties.put("sasl.mechanism", "SCRAM-SHA-512");
        kafkaConsumerProperties.put("sasl.jaas.config", "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + LSST_SASL_USERNAME + "\" password=\"" + LSST_SASL_PASSWORD + "\";");
        this.consumer_thread = new KafkaConsumerThread(kafkaConsumerProperties);
    }

    @Override
    public SALReceivedCommand<C> getNextCommand(Duration timeout) throws SALException {
        try {
            this.consumer_thread.subscribe(SALKafkaObject.SALType.COMMAND);
            return this.commandQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for command ", ex);
        }
    }

    @Override
    public SALCommandResponse issueCommand(C command) throws SALException {
        int seqNum = this.utils.getSeqNum();
        SALKafkaCommandResponse commandResponse = new SALKafkaCommandResponse(seqNum);
        this.sendObject(command, seqNum);
        return commandResponse;
    }

    @Override
    public void logEvent(E event) throws SALException {
        this.sendObject(event, this.utils.getSeqNum());
    }

    @Override
    public E getNextEvent(Duration timeout) throws SALException {
        try {
            this.consumer_thread.subscribe(SALKafkaObject.SALType.EVENT);
            return (E)((SALEvent)this.eventQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for event ", ex);
        }
    }

    @Override
    public void sendTelemetry(T telemetry) throws SALException {
        this.sendObject(telemetry, this.utils.getSeqNum());
    }

    void sendObject(Object object, int seqNum) {
        SALKafkaObject salKafkaObject = this.salFile.getSALObject(object.getClass());
        GenericRecord genericRecord = salKafkaObject.createRecord(object, this.agentName, seqNum);
        String topic = salKafkaObject.getTopic(TOPIC_NAME);
        String key = salKafkaObject.getKey();
        if (key != null) {
            LOGGER.log(Level.FINE, "Using key={0}", key);
        }
        ProducerRecord producerRecord = new ProducerRecord(topic, (Object)key, (Object)genericRecord);
        this.producer.send(producerRecord);
        this.producer.flush();
    }

    @Override
    public T getTelemetry(Duration timeout) throws SALException {
        try {
            this.consumer_thread.subscribe(SALKafkaObject.SALType.TELEMETRY);
            return (T)((SALTelemetry)this.telemetryQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for telemetry ", ex);
        }
    }

    @Override
    public void close() throws SALException {
        this.consumer_thread.close();
        this.producer.close();
    }

    @Override
    public String getSALVersion() {
        return "bogus";
    }

    @Override
    public String getXMLVersion() {
        return "bogus";
    }

    @Override
    public String getOSPLVersion() {
        return "bogus";
    }

    private class KafkaConsumerThread
    extends Thread
    implements AutoCloseable {
        private final KafkaConsumer<String, GenericRecord> consumer;
        private final ConcurrentHashMap.KeySetView<SALKafkaObject.SALType, Boolean> salTypes = ConcurrentHashMap.newKeySet();
        private volatile boolean stopConsumer = false;

        public KafkaConsumerThread(Properties kafkaConsumerProperties) {
            this.consumer = new KafkaConsumer(kafkaConsumerProperties);
            this.setName("Consumer_Thread_" + SALKafkaImplementation.this.agentName);
            this.setDaemon(true);
        }

        @Override
        public void close() {
            if (this.isAlive()) {
                this.stopConsumer = true;
                this.consumer.wakeup();
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.WARNING, "Unexpected interrupt during consumer close", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(SALKafkaObject.SALType type) {
            this.salTypes.add(type);
            if (!this.isAlive()) {
                KafkaConsumerThread kafkaConsumerThread = this;
                synchronized (kafkaConsumerThread) {
                    if (!this.isAlive()) {
                        this.start();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Pattern topicPattern = Pattern.compile(TOPIC_NAME + "." + SALKafkaImplementation.this.salFile.getCscName() + ".*");
            LOGGER.log(Level.INFO, "Using topicPattern={0}", topicPattern);
            this.consumer.subscribe(topicPattern);
            try {
                while (!this.stopConsumer) {
                    ConsumerRecords records = this.consumer.poll(Duration.ofSeconds(1L));
                    for (ConsumerRecord record : records) {
                        GenericRecord genericRecord = (GenericRecord)record.value();
                        Schema schema = genericRecord.getSchema();
                        LOGGER.log(Level.INFO, "Received {0}", schema);
                        SALKafkaObject object = SALKafkaImplementation.this.salFile.findObjectForSchema(schema);
                        if (object == null) continue;
                        LOGGER.log(Level.INFO, "{0}: {1}: {2}", new Object[]{record.topic(), record.key(), record.value()});
                        try {
                            SALKafkaObject.ObjectWithPrivateData result = object.createObjectFromRecord(genericRecord);
                            Object newInstance = result.getObject();
                            if (SALEvent.class.isAssignableFrom(newInstance.getClass())) {
                                if (this.salTypes.contains((Object)SALKafkaObject.SALType.EVENT)) {
                                    SALKafkaImplementation.this.eventQueue.add((SALEvent)newInstance);
                                }
                                LOGGER.log(Level.INFO, newInstance.toString());
                                continue;
                            }
                            if (SALTelemetry.class.isAssignableFrom(newInstance.getClass())) {
                                if (this.salTypes.contains((Object)SALKafkaObject.SALType.TELEMETRY)) {
                                    SALKafkaImplementation.this.telemetryQueue.add((SALTelemetry)newInstance);
                                }
                                LOGGER.log(Level.INFO, newInstance.toString());
                                continue;
                            }
                            if (SALCommand.class.isAssignableFrom(newInstance.getClass())) {
                                int cmdId = object.getIndex();
                                SALKafkaReceivedCommand receivedCommand = new SALKafkaReceivedCommand(cmdId, (SALCommand)newInstance, result.getIdentity(), result.getOrigin(), result.getSeqNum());
                                if (this.salTypes.contains((Object)SALKafkaObject.SALType.COMMAND)) {
                                    SALKafkaImplementation.this.commandQueue.add(receivedCommand);
                                }
                                LOGGER.log(Level.INFO, newInstance.toString());
                                continue;
                            }
                            if (newInstance instanceof SALKafkaAck) {
                                SALKafkaCommandResponse pendingResponse;
                                SALKafkaAck ack = (SALKafkaAck)newInstance;
                                if (ack.getOrigin() != SALKafkaImplementation.this.utils.getPid() || (pendingResponse = SALKafkaCommandResponse.getResponseFor(result.getSeqNum())) == null) continue;
                                pendingResponse.handleAck(ack);
                                continue;
                            }
                            throw new RuntimeException("Received unknown object " + newInstance);
                        }
                        catch (IllegalArgumentException | ReflectiveOperationException x) {
                            LOGGER.log(Level.SEVERE, "Count not create " + (String)record.key(), x);
                        }
                    }
                }
            }
            catch (Throwable x) {
                SAL.LOG.log(Level.SEVERE, "Consumer thread exiting", x);
            }
            finally {
                this.consumer.unsubscribe();
                this.consumer.close();
            }
        }
    }

    private class SALKafkaReceivedCommand
    extends SALReceivedCommand {
        private final String identity;
        private final int origin;
        private final int seqNum;

        public SALKafkaReceivedCommand(int cmdId, SALCommand command, String identity, int origin, int seqNum) {
            super(cmdId, command);
            this.identity = identity;
            this.origin = origin;
            this.seqNum = seqNum;
        }

        @Override
        public void acknowledgeCommand(Duration timeToComplete) throws SALException {
            SALKafkaAck ack = new SALKafkaAck(301, 0, "In progress", this.identity, this.origin, this.getCmdId(), SALKafkaUtils.durationToSeconds(timeToComplete));
            this.send(ack);
        }

        @Override
        public void reportComplete() throws SALException {
            SALKafkaAck ack = new SALKafkaAck(303, 0, "Done", this.identity, this.origin, this.getCmdId(), 0.0);
            this.send(ack);
        }

        @Override
        public void reportError(int errorCode, String message) throws SALException {
            SALKafkaAck ack = new SALKafkaAck(-302, errorCode, message, this.identity, this.origin, this.getCmdId(), 0.0);
            this.send(ack);
        }

        @Override
        public void rejectCommand(String reason, int errorCode) throws SALException {
            SALKafkaAck ack = new SALKafkaAck(-301, errorCode, reason, this.identity, this.origin, this.getCmdId(), 0.0);
            this.send(ack);
        }

        private void send(SALKafkaAck ack) {
            SALKafkaImplementation.this.sendObject(ack, this.seqNum);
        }
    }
}

