/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class StartEndImageTest
extends BridgeTest {
    @Test
    public void failEnd() {
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void failStart() {
        try {
            this.ocsBridge.execute(new StartImageCommand(true, "", "imageType: walrus007, groupId: fish", "annotation", 1.0));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void failEndAfterEnable() throws Exception {
        this.enabler.goToEnable(this.ocsBridge);
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void endAfterStartImageOutOfTime() throws InterruptedException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TimeUnit.SECONDS.sleep(1L);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new StartImageCommand(true, "", "imageType: walrus007, groupId: fish", "annotation", 1.0));
        TimeUnit.SECONDS.sleep(3L);
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void endAfterStartImageInTime() throws InterruptedException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        assert (this.executor.containsInOrder(AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new StartImageCommand(true, "", "imageType: walrus008, groupId: fish", "annotation", 10.0));
        TimeUnit.SECONDS.sleep(2L);
        this.ocsBridge.execute((CameraCommand)new EndImageCommand());
        TimeUnit.SECONDS.sleep(45L);
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        tl.printFinalStates("StartEndImageTest:endAfterStartImageInTime()");
        Assert.assertEquals((long)23L, (long)tl.getCalls());
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{TakeImageReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterState.CLOSED}));
        System.out.println("************************************** ");
        System.out.println("StartEndImageTest:endAfterStartImageInTime():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i).getDeclaringClass() + "." + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println("****************************************");
        System.out.println(" \n");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterReadinessState.GETTING_READY, ShutterReadinessState.READY, ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{RaftsState.CLEARING, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        System.out.println(this.executor.getEventCount());
        System.out.println(this.executor.getEventList());
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        Assert.assertTrue((boolean)event1.getImageName().startsWith("MC_O_20211231"));
        this.executor.printEventList("InitAndTakeImageTest:initAndTake()");
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, EndOfImageTelemetryEvent.class));
        EndOfImageTelemetryEvent endImageTelemetryEvent = this.executor.getEventOfClass(EndOfImageTelemetryEvent.class, 0);
        double expTime = endImageTelemetryEvent.getExposureTime();
        double measTime = endImageTelemetryEvent.getMeasuredShutterOpenTime();
        String cameraName = this.ocsBridge.getConfig().getDevice().name();
        System.out.println("************************************** ");
        System.out.println(" exposure time " + expTime + " measured time " + measTime);
        System.out.println(" Camera Name " + cameraName);
        System.out.println(" NB : A zero exposure time is ok since it isn't defined when a start image command is given.");
        System.out.println("************************************** \n");
        Assert.assertEquals((double)0.0, (double)expTime, (double)1.0E-12);
        Assert.assertEquals((double)2.0125, (double)measTime, (double)0.1);
    }
}

