/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.HashMap;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class TestStateChangeListener
implements State.StateChangeListener<Enum> {
    private final FinalStates finalStates = new FinalStates();
    private final FullStateHistory states = new FullStateHistory();
    private int calls = 0;

    TestStateChangeListener() {
    }

    public synchronized void stateChanged(CCSTimeStamp when, Enum state, Enum oldState, String cause) {
        this.finalStates.put(state.getDeclaringClass(), state);
        this.states.add(state);
        ++this.calls;
    }

    FinalStates getFinalStates() {
        return this.finalStates;
    }

    FullStateHistory getFullStateHistory() {
        return this.states;
    }

    public int getCalls() {
        return this.calls;
    }

    void printFinalStates(String testName) {
        System.out.println("**************************************");
        System.out.println(testName + ": Final States = " + this.finalStates);
        System.out.println("**************************************");
    }

    static class FinalStates
    extends HashMap<Class<? extends Enum>, Enum> {
        FinalStates() {
        }

        public boolean hasState(Enum ... statesToTest) {
            for (Enum e : statesToTest) {
                Class enumClass = e.getDeclaringClass();
                Enum state = (Enum)this.get(enumClass);
                if (state != null && state == e) continue;
                return false;
            }
            return true;
        }
    }
}

