package org.lsst.ccs.subsystem.ocsbridge;

import java.util.zip.CRC32;
import java.io.IOException;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;

/**
 * Allows any AdditionalFile to be converted to an LFA event
 * @author Farrukh Azfar 9th August 2024
 */
public class AdditionalFileToLFAEvent {

    private final LargeFileObjectAvailableEvent lfaEvent;
    private final long cksum;
    private final long byteSize;

    /**
     * Compute a checksum and length of an additional file, and create a corresponding
     * LFA event.
     * @param addFile The Additional file
     * @param url The URL the additional file can be accessed from
     * @throws java.io.IOException If unable to compute checksum
     */
    public AdditionalFileToLFAEvent(AdditionalFile addFile, String url) throws IOException {
        CRC32 cksum32 = new CRC32();
        byteSize = addFile.computeFileSizeAndChecksum(cksum32);
        cksum = cksum32.getValue();
        lfaEvent = LargeFileObjectAvailableEvent.builder()
                .byteSize((int) byteSize)
                .checkSum(String.valueOf(cksum))
                .generator(AdditionalFile.class.getCanonicalName())
                .mimeType(addFile.getMimeType())
                .url(url)
                .version(addFile.getVersion())
                .id(addFile.getFileName())
                .build();                
    }

    LargeFileObjectAvailableEvent getlfaEvent() {
        return lfaEvent;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getChecksum() {
        return this.cksum;
    }
}
