/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;

public class TelemetrySenderTest {
    @Test
    public void auxTelTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> {
            if (t instanceof Focal_plane_CcdTelemetry) {
                Focal_plane_CcdTelemetry fct = (Focal_plane_CcdTelemetry)t;
                String location = fct.getLocation();
                Assert.assertEquals((Object)"R00S00", (Object)location);
            }
            callCount.incrementAndGet();
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Camera)Camera.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        sender.getConverter().addSubsystem("ats-daq-monitor");
        sender.getConverter().addSubsystem("ats-fp");
        sender.getConverter().addSubsystem("bonn-shutter");
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-daq-monitor-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/bonn-shutter-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_aspicTemp-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_crVolt-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_rebTemp-trending.ser"));
        Assert.assertEquals((long)2L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default-trending.ser"));
        Assert.assertEquals((long)5L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)5L, (long)callCount.get());
        Thread.sleep(20000L);
        Assert.assertEquals((long)9L, (long)callCount.get());
    }

    @Test
    public void auxTelVacuumTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Camera)Camera.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        sender.getConverter().addSubsystem("ats");
        sender.send(SerializationUtils.readStatusSubsystemData((String)"auxtel/ats-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void comcamTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((Camera)Camera.COMCAM, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        sender.getConverter().addSubsystem("comcam-daq-monitor");
        sender.getConverter().addSubsystem("comcam-quadbox");
        sender.getConverter().addSubsystem("comcam-rebpower");
        sender.getConverter().addSubsystem("bonn-shutter");
        sender.send(SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-daq-monitor-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-quadbox-trending.ser"));
        Assert.assertEquals((long)6L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-rebpower-trending.ser"));
        Assert.assertEquals((long)8L, (long)callCount.get());
        sender.send(SerializationUtils.readStatusSubsystemData((String)"comcam/comcam-bonn-shutter-trending.ser"));
        Assert.assertEquals((long)9L, (long)callCount.get());
    }
}

