/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.text.ParseException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.util.KeyValueParser;

public class KeyValueParserTest {
    @Test
    public void testParse() throws ParseException {
        String test1 = "a:3, xyz : abc\t, u : \"ab c\" ";
        Map parse = KeyValueParser.parse((String)test1);
        Assert.assertEquals((long)3L, (long)parse.size());
        Assert.assertEquals((Object)"a", parse.keySet().iterator().next());
        Assert.assertEquals((Object)"3", parse.values().iterator().next());
    }

    @Test
    public void testBadParse() {
        String test1 = "a: 3, xyz: abc\t, u : \"ab c\", x";
        try {
            KeyValueParser.parse((String)test1);
            Assert.fail();
        }
        catch (ParseException x) {
            Assert.assertEquals((long)28L, (long)x.getErrorOffset());
        }
    }

    @Test
    public void testEmpty() throws ParseException {
        Map parse = KeyValueParser.parse((String)"");
        Assert.assertEquals((long)0L, (long)parse.size());
    }
}

