/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;

public class DescribeConfigsRequest
extends AbstractRequest {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String INCLUDE_SYNONYMS = "include_synonyms";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final String CONFIG_NAMES_KEY_NAME = "config_names";
    private static final String INCLUDE_DOCUMENTATION = "include_documentation";
    private static final Schema DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0 = new Schema(new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_names", ArrayOf.nullable(Type.STRING)));
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V0 = new Schema(new Field("resources", new ArrayOf(DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0), "An array of config resources to be returned."));
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V1;
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V2;
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V3;
    private final Map<ConfigResource, Collection<String>> resourceToConfigNames;
    private final boolean includeSynonyms;
    private final boolean includeDocumentation;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_CONFIGS_REQUEST_V0, DESCRIBE_CONFIGS_REQUEST_V1, DESCRIBE_CONFIGS_REQUEST_V2, DESCRIBE_CONFIGS_REQUEST_V3};
    }

    public DescribeConfigsRequest(short version, Map<ConfigResource, Collection<String>> resourceToConfigNames, boolean includeSynonyms) {
        this(version, resourceToConfigNames, includeSynonyms, false);
    }

    public DescribeConfigsRequest(short version, Map<ConfigResource, Collection<String>> resourceToConfigNames, boolean includeSynonyms, boolean includeDocumentation) {
        super(ApiKeys.DESCRIBE_CONFIGS, version);
        this.resourceToConfigNames = Objects.requireNonNull(resourceToConfigNames, "resourceToConfigNames");
        this.includeSynonyms = includeSynonyms;
        this.includeDocumentation = includeDocumentation;
    }

    public DescribeConfigsRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_CONFIGS, version);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.resourceToConfigNames = new HashMap<ConfigResource, Collection<String>>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ConfigResource.Type resourceType = ConfigResource.Type.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            Object[] configNamesArray = resourceStruct.getArray(CONFIG_NAMES_KEY_NAME);
            ArrayList<String> configNames = null;
            if (configNamesArray != null) {
                configNames = new ArrayList<String>(configNamesArray.length);
                for (Object configNameObj : configNamesArray) {
                    configNames.add((String)configNameObj);
                }
            }
            this.resourceToConfigNames.put(new ConfigResource(resourceType, resourceName), configNames);
        }
        this.includeSynonyms = struct.hasField(INCLUDE_SYNONYMS) ? struct.getBoolean(INCLUDE_SYNONYMS) : false;
        this.includeDocumentation = struct.hasField(INCLUDE_DOCUMENTATION) ? struct.getBoolean(INCLUDE_DOCUMENTATION) : false;
    }

    public Collection<ConfigResource> resources() {
        return this.resourceToConfigNames.keySet();
    }

    public Collection<String> configNames(ConfigResource resource) {
        return this.resourceToConfigNames.get(resource);
    }

    public boolean includeSynonyms() {
        return this.includeSynonyms;
    }

    public boolean includeDocumentation() {
        return this.includeDocumentation;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_CONFIGS.requestSchema(this.version()));
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.resources().size());
        for (Map.Entry<ConfigResource, Collection<String>> entry : this.resourceToConfigNames.entrySet()) {
            ConfigResource resource = entry.getKey();
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            String[] configNames = entry.getValue() == null ? null : entry.getValue().toArray(new String[0]);
            resourceStruct.set(CONFIG_NAMES_KEY_NAME, configNames);
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        struct.setIfExists(INCLUDE_SYNONYMS, (Object)this.includeSynonyms);
        struct.setIfExists(INCLUDE_DOCUMENTATION, (Object)this.includeDocumentation);
        return struct;
    }

    @Override
    public DescribeConfigsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError error = ApiError.fromThrowable(e);
        HashMap<ConfigResource, DescribeConfigsResponse.Config> errors = new HashMap<ConfigResource, DescribeConfigsResponse.Config>(this.resources().size());
        DescribeConfigsResponse.Config config = new DescribeConfigsResponse.Config(error, Collections.emptyList());
        for (ConfigResource resource : this.resources()) {
            errors.put(resource, config);
        }
        return new DescribeConfigsResponse(throttleTimeMs, errors);
    }

    public static DescribeConfigsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsRequest(ApiKeys.DESCRIBE_CONFIGS.parseRequest(version, buffer), version);
    }

    static {
        DESCRIBE_CONFIGS_REQUEST_V2 = DESCRIBE_CONFIGS_REQUEST_V1 = new Schema(new Field(RESOURCES_KEY_NAME, new ArrayOf(DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0), "An array of config resources to be returned."), new Field(INCLUDE_SYNONYMS, Type.BOOLEAN));
        DESCRIBE_CONFIGS_REQUEST_V3 = new Schema(new Field(RESOURCES_KEY_NAME, new ArrayOf(DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0), "An array of config resources to be returned."), new Field(INCLUDE_SYNONYMS, Type.BOOLEAN), new Field(INCLUDE_DOCUMENTATION, Type.BOOLEAN));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeConfigsRequest> {
        private final Map<ConfigResource, Collection<String>> resourceToConfigNames;
        private boolean includeSynonyms;
        private boolean includeDocumentation;

        public Builder(Map<ConfigResource, Collection<String>> resourceToConfigNames) {
            super(ApiKeys.DESCRIBE_CONFIGS);
            this.resourceToConfigNames = Objects.requireNonNull(resourceToConfigNames, "resourceToConfigNames");
        }

        public Builder includeSynonyms(boolean includeSynonyms) {
            this.includeSynonyms = includeSynonyms;
            return this;
        }

        public Builder includeDocumentation(boolean includeDocumentation) {
            this.includeDocumentation = includeDocumentation;
            return this;
        }

        public Builder(Collection<ConfigResource> resources) {
            this(Builder.toResourceToConfigNames(resources));
        }

        private static Map<ConfigResource, Collection<String>> toResourceToConfigNames(Collection<ConfigResource> resources) {
            HashMap<ConfigResource, Collection<String>> result = new HashMap<ConfigResource, Collection<String>>(resources.size());
            for (ConfigResource resource : resources) {
                result.put(resource, null);
            }
            return result;
        }

        @Override
        public DescribeConfigsRequest build(short version) {
            return new DescribeConfigsRequest(version, this.resourceToConfigNames, this.includeSynonyms, this.includeDocumentation);
        }
    }
}

