/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListenerList;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALHasErrorCode;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class OCSBridgeSALLayer
extends OCSCommandExecutor {
    private final OCSBridge bridge;
    private final SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr;
    private boolean shutdown = false;
    private static final Logger logger = Logger.getLogger(OCSBridgeSALLayer.class.getName());
    private Thread commandThread;
    private Thread eventThread;
    private SALReceivedCommand<CameraCommand> currentCommand;
    private final EventListenerList<SALEvent> eventListenerList = new EventListenerList();

    OCSBridgeSALLayer(OCSBridge bridge) {
        super(bridge);
        this.bridge = bridge;
        this.mgr = bridge.getConfig().getSALManager();
    }

    public void start() {
        SAL<SALCommand, SALEvent, SALTelemetry> mountMgr;
        SAL<SALCommand, SALEvent, SALTelemetry> rotatorMgr;
        Thread t = new Thread("SALCommandReceiver"){

            @Override
            public void run() {
                try {
                    OCSBridgeSALLayer.this.runCommandLoop();
                }
                catch (SALException x) {
                    logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                }
            }
        };
        t.start();
        final SAL<SALCommand, SALEvent, SALTelemetry> headerServiceMgr = this.bridge.getConfig().getHeaderServiceManager();
        if (headerServiceMgr != null) {
            Thread headerServiceThread = new Thread("SALHeaderServiceEventReceiver"){

                @Override
                public void run() {
                    try {
                        OCSBridgeSALLayer.this.runEventLoop((SAL<SALCommand, SALEvent, SALTelemetry>)headerServiceMgr);
                    }
                    catch (SALException x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                    }
                }
            };
            headerServiceThread.start();
        }
        if ((rotatorMgr = this.bridge.getConfig().getMTRotatorManager()) != null) {
            Thread rotatorManagerThread = new Thread("SALRotatorEventReceiver"){

                @Override
                public void run() {
                    try {
                        OCSBridgeSALLayer.this.runEventLoop((SAL<SALCommand, SALEvent, SALTelemetry>)rotatorMgr);
                    }
                    catch (SALException x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                    }
                }
            };
            rotatorManagerThread.start();
        }
        if ((mountMgr = this.bridge.getConfig().getMTMountManager()) != null) {
            Thread mountManagerThread = new Thread("SALMountEventReceiver"){

                @Override
                public void run() {
                    try {
                        OCSBridgeSALLayer.this.runEventLoop((SAL<SALCommand, SALEvent, SALTelemetry>)mountMgr);
                    }
                    catch (SALException x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                    }
                }
            };
            mountManagerThread.start();
        }
    }

    private void runCommandLoop() throws SALException {
        try {
            this.commandThread = Thread.currentThread();
            while (!this.shutdown) {
                this.currentCommand = this.mgr.getNextCommand(Duration.ofMinutes(1L));
                if (this.currentCommand == null) {
                    logger.fine("Still waiting for a command");
                    continue;
                }
                this.bridge.execute((CameraCommand)this.currentCommand.getCommand());
            }
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while waiting for commands", ex);
            throw ex;
        }
        finally {
            this.commandThread = null;
        }
    }

    private void runEventLoop(SAL<SALCommand, SALEvent, SALTelemetry> headerServiceMgr) throws SALException {
        try {
            this.eventThread = Thread.currentThread();
            while (!this.shutdown) {
                SALEvent currentEvent = headerServiceMgr.getNextEvent(Duration.ofMinutes(1L));
                if (currentEvent == null) {
                    logger.fine("Still waiting for an event");
                    continue;
                }
                this.eventListenerList.fireEvent((Object)currentEvent);
            }
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while waiting for event", ex);
            throw ex;
        }
        finally {
            this.eventThread = null;
        }
    }

    void addSALEventListener(EventListener<SALEvent> eventHandler) {
        this.eventListenerList.addEventListener(eventHandler);
    }

    void removeSALEventListener(EventListener<SALEvent> eventHandler) {
        this.eventListenerList.removeEventListener(eventHandler);
    }

    private void shutdown() throws InterruptedException {
        this.shutdown = true;
        if (this.commandThread != null) {
            this.commandThread.join();
        }
        if (this.eventThread != null) {
            this.eventThread.join();
        }
    }

    @Override
    protected void reportComplete(OCSCommandExecutor.OCSExecutor command) {
        super.reportComplete(command);
        try {
            this.currentCommand.reportComplete();
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void reportError(OCSCommandExecutor.OCSExecutor command, Exception ex) {
        super.reportError(command, ex);
        try {
            int errorCode = 0;
            StringBuilder meaningfullMessage = new StringBuilder();
            for (Throwable current = ex; current != null; current = current.getCause()) {
                if (current instanceof ExecutionException || current instanceof CommandInvocationException) continue;
                if (meaningfullMessage.length() > 0) {
                    meaningfullMessage.append("\n\t");
                }
                if (current.getMessage() == null) {
                    meaningfullMessage.append(current.toString());
                } else {
                    meaningfullMessage.append(current.getMessage());
                }
                if (!(current instanceof SALHasErrorCode) || errorCode != 0) continue;
                errorCode = ((SALHasErrorCode)current).getErrorCode();
            }
            this.currentCommand.reportError(errorCode, meaningfullMessage.toString());
        }
        catch (SALException x) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", x);
        }
    }

    @Override
    protected void acknowledgeCommand(OCSCommandExecutor.OCSExecutor command, Duration timeout) {
        super.acknowledgeCommand(command, timeout);
        try {
            this.currentCommand.acknowledgeCommand(timeout);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void rejectCommand(OCSCommandExecutor.OCSExecutor command, String reason) {
        super.rejectCommand(command, reason);
        try {
            this.currentCommand.rejectCommand(reason, 0);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    public void sendEvent(CameraEvent event) {
        super.sendEvent(event);
        try {
            this.mgr.logEvent((SALEvent)event);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending event to SAL " + event.getClass(), ex);
        }
    }

    @Override
    public void sendTelemetry(CameraTelemetry telemetry) {
        super.sendTelemetry(telemetry);
        try {
            this.mgr.sendTelemetry((SALTelemetry)telemetry);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending telemetry to SAL " + telemetry.getClass(), ex);
        }
    }

    @Override
    String getSALVersion() {
        return this.mgr.getSALVersion();
    }

    @Override
    String getXMLVersion() {
        return this.mgr.getXMLVersion();
    }

    @Override
    String getOSPLVersion() {
        return this.mgr.getOSPLVersion();
    }
}

