/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.LFAAndJsonCheckAndS3WriteTest;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class TakeImagesTest
extends BridgeTest {
    public TakeImagesTest() {
        this(Camera.MAIN_CAMERA);
    }

    TakeImagesTest(Camera camera) {
        super(camera);
    }

    @Test
    public void takeImagesFail() {
        try {
            this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, "", "imageType: mockturtle001, groupId: group", "annotation"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void interruptTakeImages() throws InterruptedException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                TakeImagesTest.this.ocsBridge.execute(new TakeImagesCommand(1, 5.0, true, "", "imageType: mockturtle002, groupId: group", "annotation"));
            }
        });
        t.start();
        TimeUnit.SECONDS.sleep(5L);
        TimeUnit.SECONDS.sleep(5L);
    }

    @Test
    public void takeImages() throws InterruptedException, ExecutionException, TimeoutException, Exception {
        int i;
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, "", "imageType: mockturtle002, groupId: group", "annotation"));
        TimeUnit.SECONDS.sleep(16L);
        Assert.assertEquals((long)28L, (long)tl.getCalls());
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        this.executor.printEventList("TakeImagesTest,takeImages()");
        Assert.assertEquals((long)28L, (long)states.size());
        Assert.assertEquals((Object)states.get(0), (Object)CCSCommandStateEvent.CCSCommandState.BUSY);
        tl.printFinalStates("TakeImagesTest,takeImages()");
        fsh.printStateHistory("TakeImagesTest,takeImages()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterReadinessState.GETTING_READY, ShutterReadinessState.READY, ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{RaftsState.CLEARING, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.INTEGRATING, RaftsState.READING_OUT, RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED, ShutterState.OPENING, ShutterState.OPEN, ShutterState.CLOSING, ShutterState.CLOSED}));
        System.out.println(" List of states from takeImagesTest - two images :");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        int numCalls = 16;
        if (this.ocsBridge.getConfig().getDevice() == Camera.MAIN_CAMERA) {
            numCalls = 20;
        }
        int assertComp = numCalls;
        if (!LFAAndJsonCheckAndS3WriteTest.isS3Up()) {
            if (this.ocsBridge.getConfig().getDevice() == Camera.MAIN_CAMERA) {
                assertComp = 16;
            } else if (this.ocsBridge.getConfig().getDevice() == Camera.COMCAM) {
                assertComp = 16;
            }
        }
        Assert.assertEquals((long)assertComp, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartIntegrationEvent.class, StartReadoutEvent.class, EndReadoutEvent.class, StartIntegrationEvent.class, StartReadoutEvent.class, EndReadoutEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(EndReadoutEvent.class, EndReadoutEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        Assert.assertEquals((Object)"mockturtle002", (Object)this.getImageType(event1));
        Assert.assertEquals((double)15.0, (double)event1.getExposureTime(), (double)1.0E-12);
        ImageName imageName1 = new ImageName(event1.getImageName());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        Assert.assertEquals((Object)"mockturtle002", (Object)this.getImageType(event2));
        Assert.assertEquals((double)15.0, (double)event2.getExposureTime(), (double)1.0E-12);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        EndOfImageTelemetryEvent event3 = this.executor.getEventOfClass(EndOfImageTelemetryEvent.class, 1);
        Assert.assertEquals((double)15.0, (double)event3.getExposureTime(), (double)1.0E-12);
        ImageName imageName3 = new ImageName(event3.getImageName());
        Assert.assertEquals((Object)imageName2, (Object)imageName3);
        double measuredShutterTime = this.ocsBridge.getConfig().getDevice() == Camera.MAIN_CAMERA ? 15.1 : 15.0;
        Assert.assertEquals((double)measuredShutterTime, (double)event3.getMeasuredShutterOpenTime(), (double)1.0E-12);
    }

    private String getImageType(StartIntegrationEvent event) {
        DelimitedStringSplitJoin sj = new DelimitedStringSplitJoin();
        Map zip = sj.zip((CharSequence)event.getAdditionalKeys(), (CharSequence)event.getAdditionalValues());
        return (String)zip.get("imageType");
    }
}

