/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;

public class CCSCommandExecutor {
    private static final Logger logger = Logger.getLogger(OCSBridge.class.getName());

    void executeCommand(CCSCommand.CCSCommandResponse response) throws Exception {
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            logger.log(Level.INFO, "Command rejected: {0}", can.getReason());
            this.sendNack(can);
        } else {
            try {
                this.sendAck(can);
                response.waitForCompletion();
                logger.log(Level.INFO, "Command complete");
            }
            catch (Exception x) {
                logger.log(Level.INFO, "Command failed", x);
                throw x;
            }
        }
    }

    void sendNack(CCSCommand.CCSAckOrNack can) {
    }

    void sendAck(CCSCommand.CCSAckOrNack can) {
    }
}

