package org.lsst.ccs.subsystem.ocsbridge;

import java.util.concurrent.ExecutionException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent.CCSEventListener;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;

/**
 * A shim between the OCS bridge and the MCM. Can be implemented by direct (in-process)
 * communication, or via the CCS buses.
 * @author tonyj
 */
public interface MCMLayer {

    /**
     * Send a command to the MCM and get a response, which may include a NACK or other error
     * @param ccsCommand The command to send
     * @return The command response
     */
    public CCSCommand.CCSCommandResponse execute(CCSCommand ccsCommand);

    /**
     * Lock the MCM
     * @throws java.util.concurrent.ExecutionException
     */
    public void lock() throws ExecutionException;
    /**
     * Unlock the MCM
     * @throws java.util.concurrent.ExecutionException
     */
    public void unlock() throws ExecutionException;
    
    public void addStateChangeListener(State.StateChangeListener<Enum> stateChangeListener);
    public void removeStateChangeListener(State.StateChangeListener<Enum> stateChangeListener);
    
    public void addEventListener(CCSEventListener eventListener);
    public void removeEventListener(CCSEventListener eventListener);

    public void addStatusMessageListener(EventListener<StatusMessage> eventListener);
    public void removeStatusMessageListener(EventListener<StatusMessage> eventListener);
}
